% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locations.R
\docType{data}
\name{locations}
\alias{locations}
\title{Table of geographic location names, and associated coordinates}
\format{\describe{
   \item{Location}{Name of geographic location}
   \item{Latitude}{Latitude of location centroid}
   \item{Longitude}{Longitude of location centroid}
 }}
\usage{
data(locations)
}
\description{
Lists geographic locations that can be input to \code{\link{findHost}} or
\code{\link{findParasite}} and the corresponding latitude and longitude coordinates 
of the country's centroid. The georeferencing was performed dynamically using the 
Google Maps API, but they have since restricted access. The data on locations is now
provided in this data file called \code{locations} -- \code{data(locations)} -- and is based on 
an earlier usage of \code{ggmap}. The geographic coordinates may not be accurate, and users
should check for accuracy (and feel free to file an issue or PR on Github with corrections).
}
\references{
Gibson, D. I., Bray, R. A., & Harris, E. A. (Compilers) (2005).
Host-Parasite Database of the Natural History Museum, London.
}
\keyword{data}
