/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Residue {
    private char let;
    private int type;
    private int indexVal;
    protected static final Color[] TYPE_COLOR = new Color[]{Color.RED, Color.GRAY, Color.YELLOW, Color.MAGENTA, Color.BLUE};
    protected static final int NEG_CHARGE = 0;
    protected static final int NEG_PHILIC = 1;
    protected static final int HYDROPHOBIC = 2;
    protected static final int POS_PHILIC = 3;
    protected static final int POS_CHARGE = 4;
    protected static final Color NEG_CHARGE_COL = TYPE_COLOR[0];
    protected static final Color NEG_PHILIC_COL = TYPE_COLOR[1];
    protected static final Color HYDROPHOBIC_COL = TYPE_COLOR[2];
    protected static final Color POS_PHILIC_COL = TYPE_COLOR[3];
    protected static final Color POS_CHARGE_COL = TYPE_COLOR[4];
    private static char[] ONE_LETTERS = new char[]{'A', 'R', 'N', 'D', 'C', 'E', 'Q', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
    private static String[] THREE_LETTERS = new String[]{"ALA", "ARG", "ASN", "ASP", "CYS", "GLU", "GLN", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL"};
    private static String[] NAMES = new String[]{"ALANINE", "ARGININE", "ASPARAGINE", "ASPARTIC ACID", "CYSTEINE", "GLUTAMIC ACID", "GLUTAMINE", "GLYCINE", "HISTIDINE", "ISOLEUCINE", "LEUCINE", "LYSINE", "METHIONINE", "PHENYLALANINE", "PROLINE", "SERINE", "THREONINE", "TRYPTOPHAN", "TYROSINE", "VALINE"};
    private static int[] TYPES = new int[]{2, 4, 3, 0, 1, 0, 3, 2, 4, 2, 2, 4, 2, 2, 3, 1, 1, 2, 2, 2};

    public Residue(char c) {
        int n;
        for (n = 0; n < ONE_LETTERS.length; ++n) {
            if (c != ONE_LETTERS[n]) continue;
            this.let = c;
            this.type = TYPES[n];
            this.indexVal = n;
            break;
        }
        if (n >= THREE_LETTERS.length) {
            throw new IllegalArgumentException("Not a valid residue: " + c);
        }
    }

    public Residue(String string) {
        int n;
        for (n = 0; n < THREE_LETTERS.length; ++n) {
            if (!string.equals(THREE_LETTERS[n])) continue;
            this.let = ONE_LETTERS[n];
            this.type = TYPES[n];
            this.indexVal = n;
            break;
        }
        if (n >= THREE_LETTERS.length) {
            throw new IllegalArgumentException("Not a valid residue: " + string);
        }
    }

    public char oneLetterCode() {
        return this.let;
    }

    public String threeLetterCode() {
        return THREE_LETTERS[this.indexVal];
    }

    public String name() {
        return NAMES[this.indexVal];
    }

    public int residueType() {
        return this.type;
    }

    public Color residueColor() {
        return TYPE_COLOR[this.residueType()];
    }

    private char getOneLetter(String string) {
        for (int i = 0; i < THREE_LETTERS.length; ++i) {
            if (!string.equalsIgnoreCase(THREE_LETTERS[i])) continue;
            return ONE_LETTERS[i];
        }
        throw new IllegalArgumentException("Not a valid residue: " + string);
    }
}

