% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans-funcs.R
\name{kmeans_tidy_tbl}
\alias{kmeans_tidy_tbl}
\title{K-Means tidy Functions}
\usage{
kmeans_tidy_tbl(.kmeans_obj, .data, .tidy_type = "tidy")
}
\arguments{
\item{.kmeans_obj}{A \code{\link[stats:kmeans]{stats::kmeans()}} object}

\item{.data}{The user item tibble created from \code{\link[=kmeans_user_item_tbl]{kmeans_user_item_tbl()}}}

\item{.tidy_type}{"tidy","glance", or "augment"}
}
\value{
A tibble
}
\description{
K-Means tidy functions
}
\details{
Takes in a k-means object and its associated user item tibble and then
returns one of the items asked for. Either: \code{\link[broom:reexports]{broom::tidy()}}, \code{\link[broom:reexports]{broom::glance()}}
or \code{\link[broom:reexports]{broom::augment()}}. The function defaults to \code{\link[broom:reexports]{broom::tidy()}}.
}
\examples{
library(healthyR.data)
library(dplyr)
library(broom)

data_tbl <- healthyR_data\%>\%
   filter(ip_op_flag == "I") \%>\%
   filter(payer_grouping != "Medicare B") \%>\%
   filter(payer_grouping != "?") \%>\%
   select(service_line, payer_grouping) \%>\%
   mutate(record = 1) \%>\%
   as_tibble()

 uit_tbl <- kmeans_user_item_tbl(data_tbl, service_line, payer_grouping)
 km_obj  <- kmeans_obj(uit_tbl)
 kmeans_tidy_tbl(
   .kmeans_obj  = km_obj
   , .data      = uit_tbl
   , .tidy_type = "augment"
 )
 kmeans_tidy_tbl(
   .kmeans_obj  = km_obj
   , .data      = uit_tbl
   , .tidy_type = "glance"
 )
 kmeans_tidy_tbl(
   .kmeans_obj  = km_obj
   , .data      = uit_tbl
   , .tidy_type = "tidy"
 ) \%>\%
   glimpse()

}
\author{
Steven P. Sanderson II, MPH
}
