% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-auto-recipe.R
\name{ts_auto_recipe}
\alias{ts_auto_recipe}
\title{Build a Time Series Recipe}
\usage{
ts_auto_recipe(
  .data,
  .date_col,
  .pred_col,
  .step_ts_sig = TRUE,
  .step_ts_rm_misc = TRUE,
  .step_ts_dummy = TRUE,
  .step_ts_fourier = TRUE,
  .step_ts_fourier_period = 365/12,
  .K = 1,
  .step_ts_yeo = TRUE,
  .step_ts_nzv = TRUE
)
}
\arguments{
\item{.data}{The data that is going to be modeled. You must supply a tibble.}

\item{.date_col}{The column that holds the date for the time series.}

\item{.pred_col}{The column that is to be predicted.}

\item{.step_ts_sig}{A Boolean indicating should the \code{\link[timetk:step_timeseries_signature]{timetk::step_timeseries_signature()}}
be added, default is TRUE.}

\item{.step_ts_rm_misc}{A Boolean indicating should the following items be removed from
the time series signature, default is TRUE.
\itemize{
\item iso$
\item xts$
\item hour
\item min
\item sec
\item am.pm
}}

\item{.step_ts_dummy}{A Boolean indicating if all_nominal_predictors() should
be dummied and with one hot encoding.}

\item{.step_ts_fourier}{A Boolean indicating if \code{\link[timetk:step_fourier]{timetk::step_fourier()}} should
be added to the recipe.}

\item{.step_ts_fourier_period}{A number such as 365/12, 365/4 or 365 indicting
the period of the fourier term. The numeric period for the oscillation frequency.}

\item{.K}{The number of orders to include for each sine/cosine fourier series.
More orders increase the number of fourier terms and therefore the variance
of the fitted model at the expense of bias. See details for examples of K
specification.}

\item{.step_ts_yeo}{A Boolean indicating if the \code{\link[recipes:step_YeoJohnson]{recipes::step_YeoJohnson()}} should
be added to the recipe.}

\item{.step_ts_nzv}{A Boolean indicating if the \code{\link[recipes:step_nzv]{recipes::step_nzv()}} should be run
on all predictors.}
}
\description{
Automatically builds generic time series recipe objects from a given
tibble.
}
\details{
This will build out a couple of generic recipe objects and return those items
in a list.
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(rsample))

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

splits <- initial_time_split(
 data_tbl
 , prop = 0.8
 , cumulative = TRUE
)

ts_auto_recipe(
    .data = data_tbl
    , .date_col = date_col
    , .pred_col = value
)

ts_auto_recipe(
  .data = training(splits)
  , .date_col = date_col
  , .pred_col = value
)

}
\author{
Steven P. Sanderson II, MPH
}
