% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-arima-reg.R
\name{ts_wfs_auto_arima}
\alias{ts_wfs_auto_arima}
\title{Auto Arima (Forecast auto_arima) Workflowset Function}
\usage{
ts_wfs_auto_arima(.model_type = "auto_arima", .recipe_list)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[modeltime:arima_reg]{modeltime::arima_reg()}} under the hood and can take one of the following:
\itemize{
\item "auto_arima"
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the model specification, but if you choose you can set them
yourself if you have a good understanding of what they should be. The mode is
set to "regression".

This only uses the option \code{set_engine("auto_arima")} and therefore the .model_type
is not needed. The parameter is kept because it is possible in the future that
this could change, and it keeps with the framework of how other functions
are written.

\code{\link[modeltime:arima_reg]{modeltime::arima_reg()}} arima_reg() is a way to generate a specification of
an ARIMA model before fitting and allows the model to be created using
different packages. Currently the only package is \code{forecast}.
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(rsample))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_auto_arima("auto_arima", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}

\url{https://business-science.github.io/modeltime/reference/arima_reg.html}

Other Auto Workflowsets: 
\code{\link{ts_wfs_arima_boost}()},
\code{\link{ts_wfs_ets_reg}()},
\code{\link{ts_wfs_lin_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_nnetar_reg}()},
\code{\link{ts_wfs_prophet_reg}()},
\code{\link{ts_wfs_svm_poly}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
