% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-hai-scale-zscore.R
\name{hai_scale_zscore_vec}
\alias{hai_scale_zscore_vec}
\title{Vector Function Scale to Zero and One}
\usage{
hai_scale_zscore_vec(.x)
}
\arguments{
\item{.x}{A numeric vector to be scaled by mean and standard deviation inclusive.}
}
\value{
A numeric vector
}
\description{
Takes a numeric vector and will return a vector that has been scaled from by
mean and standard deviation
}
\details{
Takes a numeric vector and will return a vector that has been scaled from
mean and standard deviation.

The input vector must be numeric. The computation is fairly straightforward.
This may be helpful when trying to compare the distributions of data where a
distribution like beta from the \code{fitdistrplus} package which requires data to be
between 0 and 1

\deqn{y[h] = (x - mean(x) / sd(x))}

This function can be used on it's own. It is also the basis for the function
\code{\link[=hai_scale_zscore_augment]{hai_scale_zscore_augment()}}.
}
\examples{
vec_1 <- mtcars$mpg
vec_2 <- hai_scale_zscore_vec(vec_1)

ax <- pretty(min(vec_1, vec_2):max(vec_1, vec_2), n = 12)

hist(vec_1, breaks = ax, col = "blue")
hist(vec_2, breaks = ax, col = "red", add = TRUE)

}
\seealso{
Other Vector Function: 
\code{\link{hai_fourier_discrete_vec}()},
\code{\link{hai_fourier_vec}()},
\code{\link{hai_hyperbolic_vec}()},
\code{\link{hai_kurtosis_vec}()},
\code{\link{hai_scale_zero_one_vec}()},
\code{\link{hai_skewness_vec}()},
\code{\link{hai_winsorized_move_vec}()},
\code{\link{hai_winsorized_truncate_vec}()}

Other Scale: 
\code{\link{hai_scale_zero_one_augment}()},
\code{\link{hai_scale_zero_one_vec}()},
\code{\link{hai_scale_zscore_augment}()},
\code{\link{step_hai_scale_zscore}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Scale}
\concept{Vector Function}
