% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingness.R
\name{plot.missingness}
\alias{plot.missingness}
\title{Plot missingness}
\usage{
\method{plot}{missingness}(
  x,
  remove_zeros = FALSE,
  max_char = 40,
  title = NULL,
  font_size = 11,
  point_size = 3,
  print = TRUE,
  ...
)
}
\arguments{
\item{x}{Data frame from \code{\link{missingness}}}

\item{remove_zeros}{Remove variables with no missingness from the plot?
Default = FALSE}

\item{max_char}{Maximum length of variable names to leave untruncated.
Default = 40; use \code{Inf} to prevent truncation. Variable names longer
than this will be truncated to leave the beginning and end of each variable
name, bridged by " ... ".}

\item{title}{Plot title}

\item{font_size}{Relative size of all fonts in plot, default = 11}

\item{point_size}{Size of dots, default = 3}

\item{print}{Print the plot? Default = TRUE}

\item{...}{Unused}
}
\value{
A ggplot object, invisibly.
}
\description{
Plot missingness
}
\examples{
pima_diabetes \%>\%
  missingness() \%>\%
  plot()
}
\seealso{
\code{\link{missingness}}
}
