% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-package.R
\docType{data}
\name{EminentDomain}
\alias{EminentDomain}
\title{Eminent Domain data set}
\format{\describe{ 
\item{y}{economic outcome variable}
\item{x}{set of exogenous variables}
\item{d}{eminent domain decisions}
\item{z}{set of potential instruments}
}}
\description{
Dataset on judicial eminent domain decisions.
}
\details{
Data set was analyzed in Belloni et al. (2012).  They estimate the effect of judicial eminent domain decisions on economic outcomes with instrumental variables (IV) in a setting high a large set of potential IVs. 
A detailed decription of the data can be found at 
\url{https://www.econometricsociety.org/publications/econometrica/2012/11/01/sparse-models-and-methods-optimal-instruments-application} 
The data set contains four "sub-data sets" which differ mainly in the dependent variables: repeat-sales FHFA/OFHEO house price index for metro (FHFA) and non-metro (NM) area, the Case-Shiller home price index (CS), 
and state-level GDP from the Bureau of Economic Analysis - all transformed with the logarithm. The structure of each subdata set is comparable and given above.
}
\examples{
data(EminentDomain)
}
\references{
D. Belloni, D. Chen, V. Chernozhukov and C. Hansen (2012).
Sparse models and methods for optimal instruments with an application to
eminent domain. \emph{Econometrica} 80 (6), 2369--2429.
}
\keyword{datasets}

