% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_respondents.R
\name{plot_respondents}
\alias{plot_respondents}
\title{Plot estimated respondent positions}
\usage{
plot_respondents(
  object,
  inc_stimuli = TRUE,
  n_draws = 15,
  color = "#053061",
  fill = "#2166AC",
  alpha_color = 0.6,
  alpha_fill = 0.7/n_draws,
  seed = 1
)
}
\arguments{
\item{object}{An instance of class \code{stanfit} produced by \code{hbam()}.}

\item{inc_stimuli}{Logical: Should estimated stimulus positions also be shown?}

\item{n_draws}{Integer specifying the number of posterior draws to use when illustrating the uncertainty of the population distribution. Defaults to 15.}

\item{color}{Color of lines illustrating uncertainty.}

\item{fill}{Fill color for density plots.}

\item{alpha_color}{Number in [0,1]: Inverse level of transparency for line color.}

\item{alpha_fill}{Number in [0,1]: Inverse level of transparency for fill color.}

\item{seed}{A positive integer specifying an optional seed for reproducibility. The seed is used to select respondent position draws for illustrating uncertainty.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the distribution of estimated respondent positions from an HBAM model.
}
