% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{inc_gamma_imag}
\alias{inc_gamma_imag}
\title{Incomplete gamma function of imaginary argument}
\usage{
inc_gamma_imag(x, alpha)
}
\arguments{
\item{x}{A non-negative number}

\item{alpha}{A number between 0 and 1 (strictly)}
}
\value{
The incomplete gamma function of imaginary argument (see Details)
}
\description{
Calculates the value of
\deqn{\Gamma_1(x, \alpha) = \int_x^\infty t^{\alpha-1} e^{-it} \mathrm{d}t}
for \eqn{0 < \alpha < 1} through the following relations:
\deqn{\int_0^\infty t^{\alpha-1} e^{-it} \mathrm{d}t =
e^{-i\frac{\pi}{2}\alpha} \int_0^\infty t^{\alpha-1} e^{-t} \mathrm{d}t =
e^{-i\frac{\pi}{2}\alpha} \Gamma(\alpha).}
obtained by contour integration, and:
\deqn{\int_0^x t^{\alpha-1} e^{-it} \mathrm{d}t =
\int_0^x t^{\alpha-1} \mathrm{cos}(t) \mathrm{d}t -
i \int_0^x t^{\alpha-1} \mathrm{sin}(t) \mathrm{d}t =
Ci(x, \alpha) - i Si(x, \alpha)}.
The first integral is calculated using function "tgamma" from the library
"boost::math", while the functions Ci and Si are approximated via
Taylor expansions.
}
\examples{
inc_gamma_imag(1.0, 0.5)
}
