% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp_palette.R
\docType{data}
\name{scale_color_hp}
\alias{scale_color_hp}
\alias{scale_colour_hp}
\alias{scale_colour_hp_d}
\alias{scale_color_hp_d}
\alias{scale_fill_hp}
\alias{scale_fill_hp_d}
\title{Harry Potter colour scales}
\format{An object of class \code{ScaleDiscrete} (inherits from \code{Scale}, \code{ggproto}, \code{gg}) of length 16.}
\usage{
scale_color_hp(..., alpha = 1, begin = 0, end = 1, direction = 1,
  discrete = FALSE, house = "hufflepuff")

scale_colour_hp(..., alpha = 1, begin = 0, end = 1, direction = 1,
  discrete = FALSE, house = "hufflepuff")

scale_colour_hp_d

scale_color_hp_d

scale_fill_hp(..., alpha = 1, begin = 0, end = 1, direction = 1,
  discrete = FALSE, house = "hufflepuff")

scale_fill_hp_d
}
\arguments{
\item{...}{parameters to \code{discrete_scale} or \code{scale_fill_gradientn}}

\item{alpha}{pass through parameter to \code{hp}}

\item{begin}{The (corrected) hue in [0,1] at which the hp colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the hp colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are as output by \code{hp_pal}. If -1, the order of colors is reversed.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}

\item{house}{A character string indicating the colourmap from a house to use.
Four houses are available: "Gryffindor", "Slytherin", "Ravenclaw" and "Hufflepuff".}
}
\description{
Uses the Harry Potter color scale.
}
\details{
For \code{discrete == FALSE} (the default) all other arguments are as to
\link[ggplot2]{scale_fill_gradientn} or \link[ggplot2]{scale_color_gradientn}.
Otherwise the function will return a \code{discrete_scale} with the plot-computed
number of colors.
}
\examples{
library(ggplot2)

# ripped from the pages of ggplot2
ggplot(mtcars, aes(wt, mpg)) +
  geom_point(size=4, aes(colour = factor(cyl))) +
    scale_color_hp(discrete=TRUE, house = "Gryffindor") +
    theme_bw()

# ripped from the pages of ggplot2
dsub <- subset(diamonds, x > 5 & x < 6 & y > 5 & y < 6)
dsub$diff <- with(dsub, sqrt(abs(x-y))* sign(x-y))
ggplot(dsub, aes(x, y, colour=diff)) +
  geom_point() +
  scale_colour_hp(house = "Ravenclaw") +
  theme_bw()


# from the main hp example
dat <- data.frame(x = rnorm(10000), y = rnorm(10000))

ggplot(dat, aes(x = x, y = y)) +
  geom_hex() +
  coord_fixed() +
  scale_fill_hp(house = "Hufflepuff") +
  theme_bw()


}
\author{
Alejandro Jiménez Rico \email{aljrico@gmail.com}
}
\keyword{datasets}
