% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_iso.R
\name{get_iso}
\alias{get_iso}
\title{Create isochron or isodistance from IGN routing API}
\usage{
get_iso(point,
               time = NULL,
               distance = NULL,
               transport = "Voiture",
               reverse = FALSE,
               smoothing = TRUE,
               holes = TRUE,
               crs = "EPSG:4326")
}
\arguments{
\item{point}{Object of class \code{sf} or \code{sfc}. Needs to be located in
France.}

\item{time}{Duration in minute to create isochron. If \code{time} and
\code{distance} parameters are set, only \code{time} will be used.}

\item{distance}{Distance in meter to create isodistance. If \code{time} and
\code{distance} parameters are set, only \code{time} will be used.}

\item{transport}{There is two type of transport : "Voiture" (car) or "
Pieton" (pedestrian).}

\item{reverse}{A boolean corresponding to the sens of travel. If \code{FALSE},
\code{point} corresponding to the start.}

\item{smoothing}{A boolean determining whether the returned shape should
be smoothed or not}

\item{holes}{Some areas are inaccessible. If \code{TRUE} they are highlighted}

\item{crs}{System of coordinate}
}
\value{
\code{get_iso()} returned a polygon corresponding to all the points reachable
in a defined time or distance
}
\description{
Create isochron or isodistance from IGN routing API
}
\details{
Native API parameter can be find at \href{https://geoservices.ign.fr/documentation/services/services-deprecies/isochrones-isodistances}{IGN documentation}
}
\examples{
\dontrun{
library(sf)
library(tmap); tmap_mode("view")

point <- st_sfc(st_point(c(-4.340329361590764, 47.81236909325107)),
                crs = 4326)
isodistance <- get_iso(point, distance = 1000, transport = "Pieton")

qtm(isodistance)+
qtm(point, dots.col = "red")

}
}
