% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_terms.R
\name{commons_terms}
\alias{commons_terms}
\alias{hansard_commons_terms}
\title{Imports the parliamentary thesaurus. The API is rate limited to 5500 requests at a time, so some use of parameters is required.}
\usage{
commons_terms(search = NULL, class = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")

hansard_commons_terms(search = NULL, class = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{search}{A string to search the parliamentary thesaurus for.}

\item{class}{The class of definition to be returned Accepts one of 'ID', 'ORG', 'SIT', 'NAME', 'LEG','CTP', 'PBT' and 'TPG'.  Defaults to NULL}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with results from the parliamentary thesaurus.
}
\description{
Imports the parliamentary thesaurus. The API is rate limited to 5500 requests at a time, so some use of parameters is required.
}
\examples{
\dontrun{

x <- commons_terms(search='estate')

x <- commons_terms(search='estate', class='ORG')

}
}
\keyword{parliamentary}
\keyword{thesaurus}
