% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReformatDataframe.R
\name{modifyColTypes}
\alias{modifyColTypes}
\title{Return suggested appropriate dtypes for each column in rawDataFrame}
\usage{
modifyColTypes(rawDataFrame, cols = TRUE, dtype = FALSE, custom = FALSE)
}
\arguments{
\item{rawDataFrame}{Raw data.frame}

\item{cols}{Specify cols which you want to change its dtypes when custom is FALSE (default: TRUE, for all cols)}

\item{dtype}{Specify indexed matched dtypes whcih you want to update when custom is FALSE (default: FALSE, for automatically update)}

\item{custom}{Option whether set to auto/custom , you can specify your custom dtypes for cols given when setting to TRUE (default: FALSE, for auto)}
}
\value{
Return a new data.frame with appropriate dtypes suggested for each cols
}
\description{
Return suggested appropriate dtypes for each column in rawDataFrame
}
\examples{
library(handyFunctions)
data(people)
modifyColTypes(people)

}
