% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNodes}
\alias{plotNodes}
\title{Plot Nodes}
\usage{
plotNodes(doc, plot_break_pts = FALSE, nodeSize = 3, nodeColor = "red")
}
\arguments{
\item{doc}{A document processed with \code{\link[=processHandwriting]{processHandwriting()}}}

\item{plot_break_pts}{Logical value as to whether to plot nodes or break points. plot_break_pts=FALSE plots nodes and plot_break_pts=TRUE plots break point.}

\item{nodeSize}{Size of triangles printed. 3 by default. Move down to 2 or 1 for small text images.}

\item{nodeColor}{Which color the nodes should be}
}
\value{
Plot of full and thinned image with vertices overlaid.
}
\description{
This function returns a plot with the full image plotted in light gray and the skeleton printed in black, with red triangles over the vertices.
Also called from plotPath, which is a more useful function, in general.
}
\examples{
csafe_document <- list()
csafe_document$image <- csafe
csafe_document$thin <- thinImage(csafe_document$image)
csafe_document$process <- processHandwriting(csafe_document$thin, dim(csafe_document$image))
plotNodes(csafe_document)
plotNodes(csafe_document, nodeSize=6, nodeColor="black")

}
