% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ages.R
\name{assign_ages}
\alias{assign_ages}
\title{Assign ages to non-aged data based on a fitted age model}
\usage{
assign_ages(newdata, object, ...)
}
\arguments{
\item{newdata}{A vector or data.frame with size/length measurements}

\item{object}{An object of class "alk", "alk_fit", "rf_fit", or "gbm_fit" as
produced by \code{\link{fit_age_model}}}

\item{...}{Additional parameters to pass to the S3 object methods}
}
\value{
A data.frame the same as \code{newdata}, but with ages assigned based
on the model provided in \code{object}
}
\description{
Assign ages to non-aged data based on a fitted age model
}
\examples{
spp_alk <- fit_age_model(spp_data, levels = "spp")
spp_est_ages <- assign_ages(spp_data, spp_alk)
}
