% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{apply_copy_map}
\alias{apply_copy_map}
\title{Apply copy map}
\usage{
apply_copy_map(X, copy_map)
}
\arguments{
\item{X}{Sparse matrix containing columns of indicator functions.}

\item{copy_map}{the copy map}
}
\value{
A \code{dgCMatrix} sparse matrix corresponding to the design matrix
for a zero-th order highly adaptive lasso, but with all duplicated columns
(basis functions) removed.
}
\description{
OR duplicate training set columns together
}
\examples{
\donttest{
gendata <- function(n) {
  W1 <- runif(n, -3, 3)
  W2 <- rnorm(n)
  W3 <- runif(n)
  W4 <- rnorm(n)
  g0 <- plogis(0.5 * (-0.8 * W1 + 0.39 * W2 + 0.08 * W3 - 0.12 * W4))
  A <- rbinom(n, 1, g0)
  Q0 <- plogis(0.15 * (2 * A + 2 * A * W1 + 6 * A * W3 * W4 - 3))
  Y <- rbinom(n, 1, Q0)
  data.frame(A, W1, W2, W3, W4, Y)
}
set.seed(1234)
data <- gendata(100)
covars <- setdiff(names(data), "Y")
X <- as.matrix(data[, covars, drop = FALSE])
basis_list <- enumerate_basis(X)
x_basis <- make_design_matrix(X, basis_list)
copy_map <- make_copy_map(x_basis)
x_basis_uniq <- apply_copy_map(x_basis, copy_map)
}

}
