% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_diversities.R
\name{diversities_table}
\alias{diversities_table}
\title{Prints table of diversities}
\usage{
diversities_table(x, ...)
}
\arguments{
\item{x}{a hagis.diversities object generated by \code{\link[=calculate_diversities]{calculate_diversities()}}}

\item{...}{other arguments passed to \code{\link[pander:panderOptions]{pander::panderOptions()}}}
}
\value{
A \link[=pandoc.table]{pander} object of diversities
}
\description{
Print the frequency table of diversities from a \code{hagis.diversities} object
The resulting object is a \link{pander} table (a text object for Markdown) for
ease of use in reporting and viewing in the console.
}
\examples{
# Using the built-in data set, P_sojae_survey
data(P_sojae_survey)

P_sojae_survey

# calculate susceptibilities with a 60 \% cutoff value
diversities <- calculate_diversities(x = P_sojae_survey,
                                     cutoff = 60,
                                     control = "susceptible",
                                     sample = "Isolate",
                                     gene = "Rps",
                                     perc_susc = "perc.susc")

# print the diversities table
diversities_table(diversities)

}
\seealso{
\code{\link[=calculate_diversities]{calculate_diversities()}}, \code{\link[=individual_pathotypes]{individual_pathotypes()}}
}
