% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hankel.R
\name{hankel2effectivemass}
\alias{hankel2effectivemass}
\title{hankel2effectivemass}
\usage{
hankel2effectivemass(hankel, id = c(1), type = "log", range = c(0, 1),
  eps = 1e-16, sort.type = "values", sort.t0 = TRUE)
}
\arguments{
\item{hankel}{object as returned from \link{bootstrap.hankel}}

\item{id}{Integer. Index of eigenvalue to consider,
\eqn{1\leq id\leq n}{1 <= id <= n}.}

\item{type}{Character vector. Type of effective mass to use.
Must be in \code{c("log", "acosh")}}

\item{range}{Numeric vector. Value-range for the real part of the eigenvalues
(not the energies). If outside this range, the eigenvalue will be discarded}

\item{eps}{Numeric. Cut-off: if the imaginary part of the generalised
eigenvalues is larger than eps, the eigenvalue is discarded.}

\item{sort.type}{the sort algorithm to be used to sort the eigenvalues. This can be
either simply "values", or the eigenvector information is used in addition with
"vectors"}

\item{sort.t0}{Boolean. Whether to use the eigenvector at t0 or the one at deltat-1
for sorting}
}
\value{
Returns an object of S3 class \code{effectivemass}.
}
\description{
hankel2effectivemass
}
\seealso{
input is generated via \link{bootstrap.hankel}
alternatively use \link{hankel2cf}. See also
\link{bootstrap.effectivemass}

Other hankel: 
\code{\link{bootstrap.hankel_summed}()},
\code{\link{bootstrap.hankel}()},
\code{\link{gevp.hankel_summed}()},
\code{\link{gevp.hankel}()},
\code{\link{hankel2cf}()},
\code{\link{plot_hankel_spectrum}()}
}
\concept{hankel}
