% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rg.R
\name{rg}
\alias{rg}
\title{Calculate rugosity}
\usage{
rg(
  data,
  L0,
  method = "area",
  parallel = FALSE,
  ncores = (parallel::detectCores() - 1)
)
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer or a triangular mesh of class mesh3d.}

\item{L0}{Grain or resolution of calculation.}

\item{method}{If data is a RasterLayer methods "hvar" or "area" are allowed. Defaults to "hvar".}

\item{parallel}{Logical. Use parallel processing? Defaults to FALSE.}

\item{ncores}{Number of cores to use if parallel = TRUE.
(Defaults to umber of available cores - 1)}
}
\value{
Rugosity value
}
\description{
Rugosity is defined as the surface area divided by the planar area. For digital elevation models, there are two methods: "hvar" and "area".
The "hvar" method for calculating rugosity is described in Torres-Pulliza et al. (2004) and is based on height variations.
The "area" method uses the \code{\link[sp:surfaceArea]{sp::surfaceArea()}} function and is detailed in Jenness (2004).
\code{method} is ignored if \code{data} is a mesh3D object.
In that case the function uses \code{\link[Rvcg:vcgArea]{Rvcg::vcgArea()}} to calculate surface area of a triangular mesh of class mesh3d.
}
\examples{
rg(horseshoe, L0 = 0.1)
rg(mcap, L0 = 0.01)

}
\references{
Jenness, J.S. Calculating Landscape Surface Area from Digital Elevation Models. Wildlife Society Bulletin, Vol. 32, No. 3 (Autumn, 2004), pp. 829-839n
\cr\cr
Torres-Pulliza, D., Dornelas, M.A., Pizarro, O. et al. A geometric basis for surface habitat complexity and biodiversity. Nat Ecol Evol 4, 1495–1501 (2020). https://doi.org/10.1038/s41559-020-1281-8
}
