% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api.R
\name{point_to_cell}
\alias{point_to_cell}
\title{Convert point location to H3 cell index}
\usage{
point_to_cell(input = NULL, res = NULL, simple = TRUE)
}
\arguments{
\item{input}{\code{sf} object with point geometry, \code{sfc_POINT} object,
\code{sfg} point, data frame or matrix.}

\item{res}{Integer; Desired H3 resolution. See
\url{https://h3geo.org/docs/core-library/restable/} for allowable values and related dimensions.}

\item{simple}{Logical; whether to return outputs as character vector where
possible.}
}
\value{
\itemize{
\item {if \code{simple = TRUE} and one resolution is requested, a character vector
of H3 addresses.}
\item {if \code{simple = TRUE} and multiple resolutions are requested, a data
frame of H3 addresses.}
\item {if \code{simple = FALSE} and a matrix, sfc or sfg object is supplied, a
data frame of H3 addresses.}
\item {if \code{simple = FALSE} and a data frame or sf object with other
attributes is supplied, a data frame of non-spatial attributes with new
columns containing addresses for one or more H3 resolutions.}
}
}
\description{
This function takes point location data and returns a H3 cell index for each
point at the chosen resolution(s).
}
\note{
While multiple resolutions can be requested for multiple points, be
  aware of the memory demand on large datasets.
}
\examples{
# where is the Brisbane Town Hall at resolution 15?
bth <- sf::st_sfc(sf::st_point(c(153.023503, -27.468920)), crs = 4326)
bth_15 <- point_to_cell(bth, res = 15)

# where is it at several resolutions?
bth_many <- point_to_cell(bth, res = seq(10, 15), simple = FALSE)
}
