% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fmeasure.R
\name{Fmeasure}
\alias{Fmeasure}
\title{F-Measure}
\usage{
Fmeasure(perf, beta = 1, max = FALSE)
}
\arguments{
\item{perf}{a h2o object of class \code{"H2OBinomialMetrics"} which is provided
by 'h2o.performance' function.}

\item{beta}{numeric, specifying beta value, which must be higher than zero}

\item{max}{logical. default is FALSE. if TRUE, instead of providing the F-Measure
for all the thresholds, the highest F-Measure is reported.}
}
\value{
a matrix of F-Measures for different thresholds or the highest F-Measure value
}
\description{
Calculates F-Measure for any given value of Beta
}
\examples{

\donttest{
library(h2o)
h2o.init(ignore_config = TRUE)
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, max_runtime_secs = 30)

# evaluate the model performance
perf <- h2o.performance(aml@leader, xval = TRUE)

# evaluate F-Measure for a Beta = 3
Fmeasure(perf, beta = 3, max = TRUE)

# evaluate F-Measure for a Beta = 1.5
Fmeasure(perf, beta = 1.5, max = TRUE)

# evaluate F-Measure for a Beta = 4
Fmeasure(perf, beta = 4, max = TRUE)

}
}
\author{
E. F. Haghish
}
