% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.startGLMJob}
\alias{h2o.startGLMJob}
\title{Start an H2O Generalized Linear Model Job}
\usage{
h2o.startGLMJob(x, y, training_frame, model_id, validation_frame,
  max_iterations = 50, beta_epsilon = 0, solver = c("IRLSM", "L_BFGS"),
  standardize = TRUE, family = c("gaussian", "binomial", "poisson", "gamma",
  "tweedie"), link = c("family_default", "identity", "logit", "log",
  "inverse", "tweedie"), tweedie_variance_power = NaN,
  tweedie_link_power = NaN, alpha = 0.5, prior = 0, lambda = 1e-05,
  lambda_search = FALSE, nlambdas = -1, lambda_min_ratio = 1,
  nfolds = 0, beta_constraints = NULL, ...)
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables to use in building the GLM model.}

\item{y}{A character string or index that represent the response variable in the model.}

\item{training_frame}{An H2O Frame object containing the variables in the model.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If none is given, an id will automatically be generated.}

\item{validation_frame}{An H2O Frame object containing the variables in the model.  Defaults to NULL.}

\item{max_iterations}{A non-negative integer specifying the maximum number of iterations.}

\item{beta_epsilon}{A non-negative number specifying the magnitude of the maximum difference between the coefficient estimates from successive iterations.
Defines the convergence criterion for \code{h2o.glm}.}

\item{solver}{A character string specifying the solver used: IRLSM (supports more features), L_BFGS (scales better for datasets with many columns)}

\item{standardize}{A logical value indicating whether the numeric predictors should be standardized to have a mean of 0 and a variance of 1 prior to
training the models.}

\item{family}{A character string specifying the distribution of the model:  gaussian, binomial, poisson, gamma, tweedie.}

\item{link}{A character string specifying the link function. The default is the canonical link for the \code{family}. The supported links for each of
the \code{family} specifications are:\cr
\code{"gaussian"}: \code{"identity"}, \code{"log"}, \code{"inverse"}\cr
\code{"binomial"}: \code{"logit"}, \code{"log"}\cr
\code{"poisson"}: \code{"log"}, \code{"identity"}\cr
\code{"gamma"}: \code{"inverse"}, \code{"log"}, \code{"identity"}\cr
\code{"tweedie"}: \code{"tweedie"}\cr}

\item{tweedie_variance_power}{A numeric specifying the power for the variance function when \code{family = "tweedie"}.}

\item{tweedie_link_power}{A numeric specifying the power for the link function when \code{family = "tweedie"}.}

\item{alpha}{A numeric in [0, 1] specifying the elastic-net mixing parameter.
The elastic-net penalty is defined to be:
\deqn{P(\alpha,\beta) = (1-\alpha)/2||\beta||_2^2 + \alpha||\beta||_1 = \sum_j [(1-\alpha)/2 \beta_j^2 + \alpha|\beta_j|]},
making \code{alpha = 1} the lasso penalty and \code{alpha = 0} the ridge penalty.}

\item{prior}{(Optional) A numeric specifying the prior probability of class 1 in the response when \code{family = "binomial"}.
The default prior is the observational frequency of class 1.}

\item{lambda}{A non-negative shrinkage parameter for the elastic-net, which multiplies \eqn{P(\alpha,\beta)} in the objective function.
When \code{lambda = 0}, no elastic-net penalty is applied and ordinary generalized linear models are fit.}

\item{lambda_search}{A logical value indicating whether to conduct a search over the space of lambda values starting from the lambda max, given
\code{lambda} is interpreted as lambda min.}

\item{nlambdas}{The number of lambda values to use when \code{lambda_search = TRUE}.}

\item{lambda_min_ratio}{Smallest value for lambda as a fraction of lambda.max. By default if the number of observations is greater than the
the number of variables then \code{lambda_min_ratio} = 0.0001; if the number of observations is less than the number
of variables then \code{lambda_min_ratio} = 0.01.}

\item{nfolds}{(Optional) Number of folds for cross-validation. If \code{nfolds >= 2}, then \code{validation} must remain empty.}

\item{beta_constraints}{A data.frame or H2OParsedData object with the columns ["names",
"lower_bounds", "upper_bounds", "beta_given"], where each row corresponds to a predictor
in the GLM. "names" contains the predictor names, "lower_bounds" and "upper_bounds" are the lower
and upper bounds of beta, and "beta_given" is some supplied starting values for beta.}

\item{...}{(Currently Unimplemented)
coefficients.}
}
\value{
Returns a \linkS4class{H2OModelFuture} class object.
}
\description{
Creates a background H2O GLM job.
}

