% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.make_metrics}
\alias{h2o.make_metrics}
\title{Create Model Metrics from predicted and actual values in H2O}
\usage{
h2o.make_metrics(
  predicted,
  actuals,
  domain = NULL,
  distribution = NULL,
  weights = NULL,
  treatment = NULL,
  auc_type = "NONE",
  auuc_type = "AUTO",
  auuc_nbins = -1
)
}
\arguments{
\item{predicted}{An H2OFrame containing predictions}

\item{actuals}{An H2OFrame containing actual values}

\item{domain}{Vector with response factors for classification.}

\item{distribution}{Distribution for regression.}

\item{weights}{(optional) An H2OFrame containing observation weights.}

\item{treatment}{(optional, for uplift models only) An H2OFrame containing treatment column for uplift classification.}

\item{auc_type}{(optional) For multinomial classification you have to specify which type of agregated AUC/AUCPR will be used to calculate this metric.}

\item{auuc_type}{(optional) For uplift binomial classification you have to specify which type of AUUC will be used to 
calculate this metric. Possibilities are gini, lift, gain, AUTO. Default is AUTO which means qini.}

\item{auuc_nbins}{(optional) For uplift binomial classification you have to specify number of bins to be used 
for calculation the AUUC. Default is -1, which means 1000.}
}
\value{
Returns an object of the \linkS4class{H2OModelMetrics} subclass.
}
\description{
Given predicted values (target for regression, class-1 probabilities or binomial
or per-class probabilities for multinomial), compute a model metrics object
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate$CAPSULE <- as.factor(prostate$CAPSULE)
prostate_gbm <- h2o.gbm(3:9, "CAPSULE", prostate)
pred <- h2o.predict(prostate_gbm, prostate)[, 3] ## class-1 probability
h2o.make_metrics(pred, prostate$CAPSULE)
}
}
