% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.sd}
\alias{h2o.sd}
\alias{sd}
\title{Standard Deviation of a column of data.}
\usage{
h2o.sd(x, na.rm = FALSE)

sd(x, na.rm = FALSE)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{na.rm}{\code{logical}. Should missing values be removed?}
}
\description{
Obtain the standard deviation of a column of data.
}
\examples{
\donttest{
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
sd(prostate.hex$AGE)
}
}
\seealso{
\code{\link{h2o.var}} for variance, and \code{\link[stats]{sd}} for the base R implementation.
}

