% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gyro.R
\encoding{UTF-8}
\name{gyrosegment}
\alias{gyrosegment}
\title{Gyrosegment}
\usage{
gyrosegment(A, B, s = 1, model = "U", n = 100)
}
\arguments{
\item{A, B}{two distinct points (of the same dimension)}

\item{s}{positive number, the radius of the Poincaré ball if
\code{model="M"}, otherwise, if \code{model="U"}, this number
defines the hyperbolic curvature}

\item{model}{the hyperbolic model, either \code{"M"} (Möbius model, i.e.
Poincaré model) or \code{"U"} (Ungar model, i.e. hyperboloid model)}

\item{n}{number of points forming the gyrosegment from \code{A} to \code{B}}
}
\value{
A numeric matrix with \code{n} rows. Each row is a point of the
  gyrosegment from \code{A} (the first row) to \code{B} (the last row).
}
\description{
Gyrosegment joining two given points.
}
\note{
The gyrosegment is obtained from \code{\link{gyroABt}} by varying
\code{t} from \code{0} to \code{1}.
}
\examples{
library(gyro)
# a 2D example ####
A <- c(1, 2); B <- c(1, 1)
opar <- par(mfrow = c(1, 2), mar = c(2, 2, 2, 0.5))
plot(rbind(A, B), type = "p", pch = 19, xlab = NA, ylab = NA,
     xlim = c(0, 2), ylim = c(0, 2), main = "s = 0.2")
s <- 0.2
AB <- gyrosegment(A, B, s)
lines(AB, col = "blue", lwd = 2)
text(t(A), expression(italic(A)), pos = 2)
text(t(B), expression(italic(B)), pos = 3)
# this is an hyperbola whose asymptotes meet at the origin
# approximate asymptotes
lines(rbind(c(0, 0), gyroABt(A, B, t = -20, s)), lty = "dashed")
lines(rbind(c(0, 0), gyroABt(A, B, t = 20, s)), lty = "dashed")
# plot the gyromidoint
points(
 rbind(gyromidpoint(A, B, s)),
 type = "p", pch = 19, col = "red"
)
# another one, with a different `s`
plot(rbind(A, B), type = "p", pch = 19, xlab = NA, ylab = NA,
     xlim = c(0, 2), ylim = c(0, 2), main = "s = 0.1")
s <- 0.1
AB <- gyrosegment(A, B, s)
lines(AB, col = "blue", lwd = 2)
text(t(A), expression(italic(A)), pos = 2)
text(t(B), expression(italic(B)), pos = 3)
# approximate asymptotes
lines(rbind(c(0, 0), gyroABt(A, B, t = -20, s)), lty = "dashed")
lines(rbind(c(0, 0), gyroABt(A, B, t = 20, s)), lty = "dashed")
# plot the gyromidoint
points(
 rbind(gyromidpoint(A, B, s)),
 type = "p", pch = 19, col = "red"
)

# a 3D hyperbolic triangle ####
library(rgl)
A <- c(1, 0, 0); B <- c(0, 1, 0); C <- c(0, 0, 1)
s <- 0.3
AB <- gyrosegment(A, B, s)
AC <- gyrosegment(A, C, s)
BC <- gyrosegment(B, C, s)
view3d(30, 30, zoom = 0.75)
lines3d(AB, lwd = 3); lines3d(AC, lwd = 3); lines3d(BC, lwd = 3)
}
