% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.diag.plots.R
\name{elliptical.diag.plots}
\alias{elliptical.diag.plots}
\title{Diagnostic Plots for Elliptical Regression Models}
\usage{
elliptical.diag.plots(
  object,
  ellipticaldiag = NULL,
  which,
  subset = NULL,
  iden = FALSE,
  labels = NULL,
  ret = FALSE,
  ...
)
}
\arguments{
\item{object}{an object with the result of the fitted elliptical regression model.}

\item{ellipticaldiag}{object list containing the diagnostic measures. By default it is obtained from the object, but can be calculated using \code{\link{elliptical.diag}}.}

\item{which}{an optional numeric value with the number of only plot that must be returned.}

\item{subset}{an optional numeric vector specifying a subset of observations to be used in the fitting process.}

\item{iden}{a logical value used to identify observations. If \code{TRUE} the observations are identified by user in the graphic window.}

\item{labels}{a optional string vector specifying a labels plots.}

\item{ret}{a logical value used to return the diagnostic measures computing. If \code{TRUE} the diagnostic measures are returned (see \code{\link{elliptical.diag}} for more details).}

\item{...}{graphics parameters to be passed to the plotting routines.}
}
\value{
Return an interactive menu with eleven options to make plots. This menu contains the follows graphics:
1: plot: All.
2: plot: Response residual against fitted values.
3: plot: Response residual against index.
4: plot: Standardized residual against fitted values.
5: plot: Standardized residual against index.
6: plot: QQ-plot of response residuals.
7: plot: QQ-plot of standardized residuals.
8: plot: Generalized leverage.
9: plot: Total local influence index plot for response perturbation.
10: plot: Total local influence index plot scale perturbation.
11: plot: Total local influence index plot case-weight perturbation.
}
\description{
This function generate diagnostic measures plots for the fitted elliptical regression models.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5),
data=luz)
elliptical.diag.plots(elliptical.fitt, which=3)
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\doi{10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}, \code{\link{elliptical.diag}}
}
\keyword{Diagnostic}
\keyword{Elliptical}
\keyword{methods}
\keyword{models}
\keyword{regression}
