% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.elliptical.R
\name{family.elliptical}
\alias{family.elliptical}
\title{Family Objects for Elliptical Models}
\usage{
\method{family}{elliptical}(object, ...)
}
\arguments{
\item{object}{fit object for elliptical regression model.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
An object of class "family" (which has a concise print method). This is a list with elements:
\item{family}{character: the family name.}
\item{g0, g1, g2, g3, g4, g5}{derived fuctions associated with the distribution family defined.}
\item{df}{degree of freedom for t-student distribution.}
\item{s, r}{shape parameters for generalized t-student distribution.}
\item{alpha}{shape parameter for contaminated normal and generalized logistic distributions.}  
\item{mp}{shape parameter for generalized logistic distribution.}
\item{epsi}{dispersion parameter for contaminated normal distribution.}
\item{sigmap}{dispersion parameter for contaminated normal distribution.}
\item{k}{shape parameter for power exponential distribution.}
}
\description{
Family objects provide a convenient way to specify the details of the models used by functions such as \code{elliptical}. See the documentation for \code{elliptical} or \code{egwr} for the details on how such model fitting takes place.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Normal()
,data=luz)
family(elliptical.fitt)
}
\references{
Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{elliptical}}, \code{\link{gwer}}
}
\keyword{distributions}
\keyword{elliptical}
