% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_table_styling.R
\name{modify_table_styling}
\alias{modify_table_styling}
\title{Modify Table Styling}
\usage{
modify_table_styling(
  x,
  columns,
  rows = NULL,
  label = NULL,
  spanning_header = NULL,
  hide = NULL,
  footnote = NULL,
  footnote_abbrev = NULL,
  align = NULL,
  missing_symbol = NULL,
  fmt_fun = NULL,
  text_format = NULL,
  undo_text_format = NULL,
  indent = NULL,
  text_interpret = "md",
  cols_merge_pattern = NULL
)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
gtsummary object}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Selector of columns in \code{x$table_body}}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Can be used to style footnote, formatting functions, missing symbols,
and text formatting. Default is \code{NULL}. See details below.}

\item{label}{(\code{character})\cr
Character vector of column label(s). Must be the same length as \code{columns}.}

\item{spanning_header}{(\code{string})\cr
string with text for spanning header}

\item{hide}{(scalar \code{logical})\cr
Logical indicating whether to hide column from output}

\item{footnote}{(\code{string})\cr
string with text for footnote}

\item{footnote_abbrev}{(\code{string})\cr
string with abbreviation definition, e.g. \code{"CI = Confidence Interval"}}

\item{align}{(\code{string})\cr
String indicating alignment of column, must be one of \code{c("left", "right", "center")}}

\item{missing_symbol}{(\code{string})\cr
string indicating how missing values are formatted.}

\item{fmt_fun}{(\code{function})\cr
function that formats the statistics in the columns/rows in \code{columns} and \code{rows}}

\item{text_format, undo_text_format}{(\code{string})\cr
String indicated which type of text formatting to apply/remove to the rows and columns.
Must be one of \code{c("bold", "italic")}.}

\item{indent}{(\code{integer})\cr
An integer indicating how many space to indent text}

\item{text_interpret}{(\code{string})\cr
Must be one of \code{"md"} or \code{"html"} and indicates the processing function
as \code{gt::md()} or \code{gt::html()}. Use this in conjunction with arguments for
header and footnotes.}

\item{cols_merge_pattern}{(\code{string})\cr
glue-syntax string indicating how to merge
columns in \code{x$table_body}. For example, to construct a confidence interval
use \code{"{conf.low}, {conf.high}"}. The first column listed in the pattern
string must match the single column name passed in \verb{columns=}.}
}
\description{
\strong{This function is for developers.}
\emph{This function has very little checking of the passed arguments, by design.}

If you are not a developer, it's recommended that you use the following
functions to make modifications to your table:

\code{\link[=modify_header]{modify_header()}},
\code{\link[=modify_spanning_header]{modify_spanning_header()}}, \code{\link[=modify_column_hide]{modify_column_hide()}}, \code{\link[=modify_column_unhide]{modify_column_unhide()}},
\code{\link[=modify_footnote_header]{modify_footnote_header()}}, \code{\link[=modify_footnote_body]{modify_footnote_body()}}, \code{\link[=modify_abbreviation]{modify_abbreviation()}},
\code{\link[=modify_column_alignment]{modify_column_alignment()}}, \code{\link[=modify_fmt_fun]{modify_fmt_fun()}}, \code{\link[=modify_column_indent]{modify_column_indent()}},
\code{\link[=modify_column_merge]{modify_column_merge()}}, \code{\link[=modify_missing_symbol]{modify_missing_symbol()}}, \code{\link[=modify_bold]{modify_bold()}},
\code{\link[=modify_italic]{modify_italic()}}.

This is a function provides control over the characteristics of the resulting
gtsummary table by directly modifying \code{.$table_styling}.

Review the
\href{https://www.danieldsjoberg.com/gtsummary/articles/gtsummary_definition.html}{gtsummary definition}
vignette for information on \code{.$table_styling} objects.
}
\section{rows argument}{

The rows argument accepts a predicate expression that is used to specify
rows to apply formatting. The expression must evaluate to a logical when
evaluated in \code{x$table_body}. For example, to apply formatting to the age rows
pass \code{rows = variable == "age"}. A vector of row numbers is NOT acceptable.

A couple of things to note when using the \code{rows} argument.
\enumerate{
\item You can use saved objects to create the predicate argument, e.g.
\code{rows = variable == letters[1]}.
\item The saved object cannot share a name with a column in \code{x$table_body}.
The reason for this is that in \code{tbl_merge()} the columns are renamed,
and the renaming process cannot disambiguate the \code{variable} column from
an external object named \code{variable} in the following expression
\code{rows = .data$variable = .env$variable}.
}
}

\section{cols_merge_pattern argument}{


There are planned updates to the implementation of column merging.
Currently, this function replaces the numeric column with a
formatted character column following \verb{cols_merge_pattern=}.
Once \code{gt::cols_merge()} gains the \verb{rows=} argument the
implementation will be updated to use it, which will keep
numeric columns numeric. For the \emph{vast majority} of users,
\emph{the planned change will be go unnoticed}.

If this functionality is used in conjunction with \code{tbl_stack()} (which
includes \code{tbl_uvregression()}), there is potential issue with printing.
When columns are stack AND when the column-merging is
defined with a quosure, you may run into issues due to the loss of the
environment when 2 or more quosures are combined. If the expression
version of the quosure is the same as the quosure (i.e. no evaluated
objects), there should be no issues. Regardless, this argument is used
internally with care, and it is \emph{not} recommended for users.
}

\seealso{
See \href{https://www.danieldsjoberg.com/gtsummary/articles/gtsummary_definition.html}{gtsummary internals vignette}

Other Advanced modifiers: 
\code{\link{modify_column_indent}()},
\code{\link{modify_column_merge}()}
}
\concept{Advanced modifiers}
\keyword{internal}
