% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{tests}
\alias{tests}
\title{Tests/methods available in \code{add_p()} and \code{add_difference()}}
\description{
Below is a listing of tests available internally within gtsummary.

Tests listed with \code{...} may have additional arguments
passed to them using \code{add_p(test.args=)}. For example, to
calculate a p-value from \code{t.test()} assuming equal variance, use
\code{tbl_summary(trial, by = trt) \%>\% add_p(age ~ "t.test", test.args = age ~ list(var.equal = TRUE))}
}
\section{tbl_summary() \%>\% add_p()}{
\tabular{llll}{
   \strong{alias} \tab \strong{description} \tab \strong{pseudo-code} \tab \strong{details} \cr
   \code{"t.test"} \tab t-test \tab \code{t.test(variable ~ as.factor(by), data = data, conf.level = 0.95, ...)} \tab  \cr
   \code{"aov"} \tab One-way ANOVA \tab \code{aov(variable ~ as.factor(by), data = data) \%>\% summary()} \tab  \cr
   \code{"kruskal.test"} \tab Kruskal-Wallis test \tab \code{kruskal.test(data[[variable]], as.factor(data[[by]]))} \tab  \cr
   \code{"wilcox.test"} \tab Wilcoxon rank-sum test \tab \code{wilcox.test(as.numeric(variable) ~ as.factor(by), data = data, ...)} \tab  \cr
   \code{"chisq.test"} \tab chi-square test of independence \tab \code{chisq.test(x = data[[variable]], y = as.factor(data[[by]]), ...)} \tab  \cr
   \code{"chisq.test.no.correct"} \tab chi-square test of independence \tab \code{chisq.test(x = data[[variable]], y = as.factor(data[[by]]), correct = FALSE)} \tab  \cr
   \code{"fisher.test"} \tab Fisher's exact test \tab \code{fisher.test(data[[variable]], as.factor(data[[by]]), conf.level = 0.95, ...)} \tab  \cr
   \code{"mcnemar.test"} \tab McNemar's test \tab \verb{tidyr::pivot_wider(id_cols = group, ...); mcnemar.test(by_1, by_2, conf.level = 0.95, ...)} \tab  \cr
   \code{"mcnemar.test.wide"} \tab McNemar's test \tab \code{mcnemar.test(data[[variable]], data[[by]], conf.level = 0.95, ...)} \tab  \cr
   \code{"lme4"} \tab random intercept logistic regression \tab \verb{lme4::glmer(by ~ (1 \\UFF5C group), data, family = binomial) \%>\% anova(lme4::glmer(by ~ variable + (1 \\UFF5C group), data, family = binomial))} \tab  \cr
   \code{"paired.t.test"} \tab Paired t-test \tab \verb{tidyr::pivot_wider(id_cols = group, ...); t.test(by_1, by_2, paired = TRUE, conf.level = 0.95, ...)} \tab  \cr
   \code{"paired.wilcox.test"} \tab Paired Wilcoxon rank-sum test \tab \verb{tidyr::pivot_wider(id_cols = group, ...); wilcox.test(by_1, by_2, paired = TRUE, conf.int = TRUE, conf.level = 0.95, ...)} \tab  \cr
   \code{"prop.test"} \tab Test for equality of proportions \tab \code{prop.test(x, n, conf.level = 0.95, ...)} \tab  \cr
   \code{"ancova"} \tab ANCOVA \tab \code{lm(variable ~ by + adj.vars)} \tab  \cr
   \code{"emmeans"} \tab Estimated Marginal Means or LS-means \tab \code{lm(variable ~ by + adj.vars, data) \%>\% emmeans::emmeans(specs =~by) \%>\% emmeans::contrast(method = "pairwise") \%>\% summary(infer = TRUE, level = conf.level)} \tab When variable is binary, \code{glm(family = binomial)} and \code{emmeans(type = "response")} arguments are used. When \code{group} is specified, \code{lme4::lmer()} and \code{lme4::glmer()} are used with the group as a random intercept. \cr
}
}

\section{tbl_svysummary() \%>\% add_p()}{
\tabular{lll}{
   \strong{alias} \tab \strong{description} \tab \strong{pseudo-code} \cr
   \code{"svy.t.test"} \tab t-test adapted to complex survey samples \tab \code{survey::svyttest(~variable + by, data)} \cr
   \code{"svy.wilcox.test"} \tab Wilcoxon rank-sum test for complex survey samples \tab \code{survey::svyranktest(~variable + by, data, test = 'wilcoxon')} \cr
   \code{"svy.kruskal.test"} \tab Kruskal-Wallis rank-sum test for complex survey samples \tab \code{survey::svyranktest(~variable + by, data, test = 'KruskalWallis')} \cr
   \code{"svy.vanderwaerden.test"} \tab van der Waerden's normal-scores test for complex survey samples \tab \code{survey::svyranktest(~variable + by, data, test = 'vanderWaerden')} \cr
   \code{"svy.median.test"} \tab Mood's test for the median for complex survey samples \tab \code{survey::svyranktest(~variable + by, data, test = 'median')} \cr
   \code{"svy.chisq.test"} \tab chi-squared test with Rao & Scott's second-order correction \tab \code{survey::svychisq(~variable + by, data, statistic = 'F')} \cr
   \code{"svy.adj.chisq.test"} \tab chi-squared test adjusted by a design effect estimate \tab \code{survey::svychisq(~variable + by, data, statistic = 'Chisq')} \cr
   \code{"svy.wald.test"} \tab Wald test of independence for complex survey samples \tab \code{survey::svychisq(~variable + by, data, statistic = 'Wald')} \cr
   \code{"svy.adj.wald.test"} \tab adjusted Wald test of independence for complex survey samples \tab \code{survey::svychisq(~variable + by, data, statistic = 'adjWald')} \cr
   \code{"svy.lincom.test"} \tab test of independence using the exact asymptotic distribution for complex survey samples \tab \code{survey::svychisq(~variable + by, data, statistic = 'lincom')} \cr
   \code{"svy.saddlepoint.test"} \tab test of independence using a saddlepoint approximation for complex survey samples \tab \code{survey::svychisq(~variable + by, data, statistic = 'saddlepoint')} \cr
}
}

\section{tbl_survfit() \%>\% add_p()}{
\tabular{lll}{
   \strong{alias} \tab \strong{description} \tab \strong{pseudo-code} \cr
   \code{"logrank"} \tab Log-rank test \tab \code{survival::survdiff(Surv(.) ~ variable, data, rho = 0)} \cr
   \code{"petopeto_gehanwilcoxon"} \tab Peto & Peto modification of Gehan-Wilcoxon test \tab \code{survival::survdiff(Surv(.) ~ variable, data, rho = 1)} \cr
   \code{"survdiff"} \tab G-rho family test \tab \code{survival::survdiff(Surv(.) ~ variable, data, ...)} \cr
   \code{"coxph_lrt"} \tab Cox regression (LRT) \tab \code{survival::coxph(Surv(.) ~ variable, data, ...)} \cr
   \code{"coxph_wald"} \tab Cox regression (Wald) \tab \code{survival::coxph(Surv(.) ~ variable, data, ...)} \cr
   \code{"coxph_score"} \tab Cox regression (Score) \tab \code{survival::coxph(Surv(.) ~ variable, data, ...)} \cr
}
}

\section{tbl_continuous() \%>\% add_p()}{
\tabular{lll}{
   \strong{alias} \tab \strong{description} \tab \strong{pseudo-code} \cr
   \code{"anova_2way"} \tab Two-way ANOVA \tab \code{lm(continuous_variable ~ by + variable)} \cr
   \code{"t.test"} \tab t-test \tab \code{t.test(continuous_variable ~ as.factor(variable), data = data, conf.level = 0.95, ...)} \cr
   \code{"aov"} \tab One-way ANOVA \tab \code{aov(continuous_variable ~ as.factor(variable), data = data) \%>\% summary()} \cr
   \code{"kruskal.test"} \tab Kruskal-Wallis test \tab \code{kruskal.test(data[[continuous_variable]], as.factor(data[[variable]]))} \cr
   \code{"wilcox.test"} \tab Wilcoxon rank-sum test \tab \code{wilcox.test(as.numeric(continuous_variable) ~ as.factor(variable), data = data, ...)} \cr
   \code{"lme4"} \tab random intercept logistic regression \tab \verb{lme4::glmer(by ~ (1 \\UFF5C group), data, family = binomial) \%>\% anova(lme4::glmer(variable ~ continuous_variable + (1 \\UFF5C group), data, family = binomial))} \cr
   \code{"ancova"} \tab ANCOVA \tab \code{lm(continuous_variable ~ variable + adj.vars)} \cr
}
}

\section{tbl_summary() \%>\% add_difference()}{
\tabular{lllll}{
   \strong{alias} \tab \strong{description} \tab \strong{difference statistic} \tab \strong{pseudo-code} \tab \strong{details} \cr
   \code{"t.test"} \tab t-test \tab mean difference \tab \code{t.test(variable ~ as.factor(by), data = data, conf.level = 0.95, ...)} \tab  \cr
   \code{"paired.t.test"} \tab Paired t-test \tab mean difference \tab \verb{tidyr::pivot_wider(id_cols = group, ...); t.test(by_1, by_2, paired = TRUE, conf.level = 0.95, ...)} \tab  \cr
   \code{"paired.wilcox.test"} \tab Paired Wilcoxon rank-sum test \tab rate difference \tab \verb{tidyr::pivot_wider(id_cols = group, ...); wilcox.test(by_1, by_2, paired = TRUE, conf.int = TRUE, conf.level = 0.95, ...)} \tab  \cr
   \code{"prop.test"} \tab Test for equality of proportions \tab rate difference \tab \code{prop.test(x, n, conf.level = 0.95, ...)} \tab  \cr
   \code{"ancova"} \tab ANCOVA \tab mean difference \tab \code{lm(variable ~ by + adj.vars)} \tab  \cr
   \code{"ancova_lme4"} \tab ANCOVA with random intercept \tab mean difference \tab \verb{lme4::lmer(variable ~ by + adj.vars + (1 \\UFF5C group), data)} \tab  \cr
   \code{"cohens_d"} \tab Cohen's D \tab standardized mean difference \tab \code{effectsize::cohens_d(variable ~ by, data, ci = conf.level, ...)} \tab  \cr
   \code{"smd"} \tab Standardized Mean Difference \tab standardized mean difference \tab \code{smd::smd(x = data[[variable]], g = data[[by]], std.error = TRUE)} \tab  \cr
   \code{"emmeans"} \tab Estimated Marginal Means or LS-means \tab adjusted mean difference \tab \code{lm(variable ~ by + adj.vars, data) \%>\% emmeans::emmeans(specs =~by) \%>\% emmeans::contrast(method = "pairwise") \%>\% summary(infer = TRUE, level = conf.level)} \tab When variable is binary, \code{glm(family = binomial)} and \code{emmeans(type = "response")} arguments are used. When \code{group} is specified, \code{lme4::lmer()} and \code{lme4::glmer()} are used with the group as a random intercept. \cr
}
}

\section{tbl_svysummary() \%>\% add_difference()}{
\tabular{llll}{
   \strong{alias} \tab \strong{description} \tab \strong{difference statistic} \tab \strong{pseudo-code} \cr
   \code{"smd"} \tab Standardized Mean Difference \tab standardized mean difference \tab \code{smd::smd(x = data$variables[[variable]], g = data$variables[[by]], w = weights(data),  std.error = TRUE)} \cr
}
}

\section{Custom Functions}{


To report a p-value (or difference) for a test not available in gtsummary, you can create a
custom function. The output is a data frame that is one line long. The
structure is similar to the output of \code{broom::tidy()} of a typical
statistical test. The \code{add_p()} and \code{add_comparison()} functions will look for columns called
\code{"p.value"}, \code{"estimate"}, \code{"conf.low"}, \code{"conf.high"}, and \code{"method"} for the
p-value, difference, confidence interval, and the test name used in the footnote.

Example calculating a p-value from a t-test assuming a common variance
between groups.\if{html}{\out{<div class="sourceCode r">}}\preformatted{ttest_common_variance <- function(data, variable, by, ...) \{
  data <- data[c(variable, by)] \%>\% dplyr::filter(complete.cases(.))
  t.test(data[[variable]] ~ factor(data[[by]]), var.equal = TRUE) \%>\%
  broom::tidy()
\}

trial[c("age", "trt")] \%>\%
  tbl_summary(by = trt) \%>\%
  add_p(test = age ~ "ttest_common_variance")
}\if{html}{\out{</div>}}

A custom \code{add_difference()} is similar, and accepts arguments \verb{conf.level=}
and \verb{adj.vars=} as well.\if{html}{\out{<div class="sourceCode r">}}\preformatted{ttest_common_variance <- function(data, variable, by, conf.level, ...) \{
  data <- data[c(variable, by)] \%>\% dplyr::filter(complete.cases(.))
  t.test(data[[variable]] ~ factor(data[[by]]), conf.level = conf.level, var.equal = TRUE) \%>\%
  broom::tidy()
\}
}\if{html}{\out{</div>}}
\subsection{Function Arguments}{

For \code{tbl_summary()} objects, the custom function will be passed the
following arguments: \code{custom_pvalue_fun(data=, variable=, by=, group=, type=, conf.level=, adj.vars=)}.
While your function may not utilize each of these arguments, these arguments
are passed and the function must accept them. We recommend including \code{...}
to future-proof against updates where additional arguments are added.

The following table describes the argument inputs for each gtsummary table type.\tabular{lllll}{
   \strong{argument} \tab \strong{tbl_summary} \tab \strong{tbl_svysummary} \tab \strong{tbl_survfit} \tab \strong{tbl_continuous} \cr
   \verb{data=} \tab A data frame \tab A survey object \tab A \code{survfit()} object \tab A data frame \cr
   \verb{variable=} \tab String variable name \tab String variable name \tab \code{NA} \tab String variable name \cr
   \verb{by=} \tab String variable name \tab String variable name \tab \code{NA} \tab String variable name \cr
   \verb{group=} \tab String variable name \tab \code{NA} \tab \code{NA} \tab String variable name \cr
   \verb{type=} \tab Summary type \tab Summary type \tab \code{NA} \tab \code{NA} \cr
   \verb{conf.level=} \tab Confidence interval level \tab \code{NA} \tab \code{NA} \tab \code{NA} \cr
   \verb{adj.vars=} \tab Character vector of adjustment variable names (e.g. used in ANCOVA) \tab \code{NA} \tab \code{NA} \tab Character vector of adjustment variable names (e.g. used in ANCOVA) \cr
   \verb{continuous_variable=} \tab \code{NA} \tab \code{NA} \tab \code{NA} \tab String of the continuous variable name \cr
}

}
}

\keyword{internal}
