% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ae.R
\name{tbl_ae}
\alias{tbl_ae}
\title{Tabulate Adverse Events}
\usage{
tbl_ae(
  data,
  id,
  ae,
  soc = NULL,
  by = NULL,
  strata = NULL,
  id_df = NULL,
  statistic = "{n} ({p})",
  by_values = NULL,
  digits = NULL,
  sort = NULL,
  zero_symbol = "\U2014",
  missing_location = c("first", "last", "hide")
)
}
\arguments{
\item{data}{Data frame}

\item{id}{Variable name of the patient ID}

\item{ae}{Variable name of the adverse event column}

\item{soc}{Variable name of the system organ class column}

\item{by}{Variable to split results by, e.g. report AEs by grade}

\item{strata}{Variable to stratify results by, e.g. report AEs summaries
by treatment group}

\item{id_df}{Optional data frame of complete id values and strata to achieve correct
base n for the situation in which not all subjects experience adverse events. See
\code{\link{df_patient_characteristics}} for an example \code{id_df} that pairs with
\code{\link{df_adverse_events}}.}

\item{statistic}{String indicating the statistics that will be reported.
The default is \code{"{n} ({p})"}}

\item{by_values}{Optional vector of complete by values, listed in desired order,
to achieve correct table structure for the situation in which an adverse
event of a certain grade is not observed for a given soc}

\item{digits}{Specifies the number of decimal places to round the summary statistics.
By default integers are shown to zero decimal places, and percentages are
formatted with \code{style_percent()}. If you would like to modify either
of these, pass a vector of integers indicating the number of decimal
places to round the statistics. For example, if the statistic being
calculated is \code{"{n} ({p}\%)"} and you want the percent rounded to
2 decimal places use \code{digits = c(0, 2)}.
User may also pass a styling function: \code{digits = style_sigfig}}

\item{sort}{Controls order of AEs and SOCs in output table.
The default is \code{NULL}, where AEs and SOCs are sorted alphanumerically
(and factors sorted according to their factor level).
Use \code{sort = "ae"} to sort AEs in decreasing frequency order, \code{sort = "soc"}
to sort SOCs in decreasing order, and \code{sort = c("ae", "soc")} to sort both.
AEs are sorted within SOC.}

\item{zero_symbol}{String used to represent cells with zero counts. Default
is the em-dash (\code{"\\U2014"}). Using \code{zero_symbol = NULL} will print the
zero count statistics, e.g. \code{"0 (0)"}}

\item{missing_location}{location where the column summarizing values with
missing levels \verb{by=} will be located in the final table. Must be
one of \verb{c("first", "last", "hide)}. Default is \code{"first"}}
}
\value{
a 'tbl_ae' object
}
\description{
The function tabulates adverse events. One AE per ID will be counted in the
resulting table. If a \verb{by=} variable is passed and a
patient experienced more than one of the same AE, the AE associated with the
highest \verb{by=} level will be included. For example, if a patient has two of
the same AE and \code{by = grade}, the AE with the highest grade will be
included.
Similarly, if tabulations within system organ class are requested, the
AE within SOC associated with the highest grade will be tabulated.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_ae_ex1.png}{options: width=95\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_ae_ex2.png}{options: width=65\%}}
}

\examples{
\donttest{
# Example 1 -----------------------------------------------------------------
tbl_ae_ex1 <-
  df_adverse_events \%>\%
  tbl_ae(
    id = patient_id,
    ae = adverse_event,
    soc = system_organ_class,
    by = grade,
    strata = trt
  ) \%>\%
  modify_header(all_ae_cols() ~ "**Grade {by}**")

# Example 2 -----------------------------------------------------------------
tbl_ae_ex2 <-
  df_adverse_events \%>\%
  tbl_ae(
    id = patient_id,
    ae = adverse_event,
    by = grade
  ) \%>\%
  modify_header(all_ae_cols() ~ "**Grade {by}**")
}
}
