% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fontawesome-icons.R
\name{gt_fa_column}
\alias{gt_fa_column}
\title{Add \code{{fontawesome}} icons inside a \code{{gt}} column.}
\usage{
gt_fa_column(
  gt_object,
  column,
  ...,
  palette = NULL,
  align = "left",
  direction = 1,
  height = "20px"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the character strings should be replaced with their corresponding \code{{fontawesome}} icons.}

\item{...}{Additional arguments passed to \code{fontawesome::fa()}}

\item{palette}{Name of palette as a string. Must be either length of 1 or a vector of valid color names/hex values of equal length to the unique levels of the column (ie if there are 4 names, there need to be 4x colors). Note that if you would like to specify a specific color to match a specific icon, you can also use a named vector like: \code{c("angle-double-up" = "#009E73", "angle-double-down" = "#D55E00","sort" = "#000000")}}

\item{align}{Character string indicating alignment of the column, defaults to "left"}

\item{direction}{The direction of the \code{paletteer} palette, should be either \code{-1} for reversed or the default of \code{1} for the existing direction.}

\item{height}{A character string indicating the height of the icon, defaults to "20px"}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_fa_column} function takes an existing \code{gt_tbl} object and
adds specific \code{fontawesome} icons based on what the names in the column are.
The icons are colored according to a palette that the user supplies, either
a vector of valid colors/hex colors of length equal to the unique levels.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
fa_cars <- mtcars \%>\%
  head() \%>\%
  dplyr::select(cyl, mpg, am, gear) \%>\%
  dplyr::mutate(man = ifelse(am == 1, "cog", "cogs")) \%>\%
  gt() \%>\%
  gt_fa_column(man)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{fa-column-cars.png}{options: width=50\%}}
}

\section{Function ID}{

2-15
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
