% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cell_text}
\alias{cell_text}
\title{Helper for defining custom text styles for table cells}
\usage{
cell_text(
  color = NULL,
  font = NULL,
  size = NULL,
  align = NULL,
  v_align = NULL,
  style = NULL,
  weight = NULL,
  stretch = NULL,
  indent = NULL,
  decorate = NULL,
  transform = NULL
)
}
\arguments{
\item{color}{The text color.}

\item{font}{The font or collection of fonts (subsequent font names are) used
as fallbacks.}

\item{size}{The size of the font. Can be provided as a number that is assumed
to represent \code{px} values (or could be wrapped in the \code{\link[=px]{px()}}) helper
function. We can also use one of the following absolute size keywords:
\code{"xx-small"}, \code{"x-small"}, \code{"small"}, \code{"medium"}, \code{"large"}, \code{"x-large"},
or \code{"xx-large"}.}

\item{align}{The text alignment. Can be one of either \code{"center"}, \code{"left"},
\code{"right"}, or \code{"justify"}.}

\item{v_align}{The vertical alignment of the text in the cell. Options are
\code{"middle"}, \code{"top"}, or \code{"bottom"}.}

\item{style}{The text style. Can be one of either \code{"normal"}, \code{"italic"}, or
\code{"oblique"}.}

\item{weight}{The weight of the font. Can be a text-based keyword such as
\code{"normal"}, \code{"bold"}, \code{"lighter"}, \code{"bolder"}, or, a numeric value between
\code{1} and \code{1000}, inclusive. Note that only variable fonts may support the
numeric mapping of weight.}

\item{stretch}{Allows for text to either be condensed or expanded. We can use
one of the following text-based keywords to describe the degree of
condensation/expansion: \code{"ultra-condensed"}, \code{"extra-condensed"},
\code{"condensed"}, \code{"semi-condensed"}, \code{"normal"}, \code{"semi-expanded"},
\code{"expanded"}, \code{"extra-expanded"}, or \code{"ultra-expanded"}. Alternatively, we
can supply percentage values from \verb{0\\\%} to \verb{200\\\%}, inclusive. Negative
percentage values are not allowed.}

\item{indent}{The indentation of the text. Can be provided as a number that
is assumed to represent \code{px} values (or could be wrapped in the \code{\link[=px]{px()}})
helper function. Alternatively, this can be given as a percentage (easily
constructed with \code{\link[=pct]{pct()}}).}

\item{decorate}{allows for text decoration effect to be applied. Here, we can
use \code{"overline"}, \code{"line-through"}, or \code{"underline"}.}

\item{transform}{Allows for the transformation of text. Options are
\code{"uppercase"}, \code{"lowercase"}, or \code{"capitalize"}.}
}
\value{
A list object of class \code{cell_styles}.
}
\description{
This helper function is to be used with the \code{\link[=tab_style]{tab_style()}} function, which
itself allows for the setting of custom styles to one or more cells. We can
also define several styles within a single call of \code{cell_text()} and
\code{\link[=tab_style]{tab_style()}} will reliably apply those styles to the targeted element.
}
\section{Figures}{

\if{html}{\figure{man_cell_text_1.png}{options: width=100\%}}
}

\section{Function ID}{

7-19
}

\examples{
# Use `exibble` to create a gt table;
# add styles with `tab_style()` and
# the `cell_text()` helper function
tab_1 <-
  exibble \%>\%
  dplyr::select(num, currency) \%>\%
  gt() \%>\%
  fmt_number(
    columns = c(num, currency),
    decimals = 1
  ) \%>\%
  tab_style(
    style = cell_text(weight = "bold"),
    locations = cells_body(
      columns = num,
      rows = num >= 5000)
  ) \%>\%
  tab_style(
    style = cell_text(style = "italic"),
    locations = cells_body(
      columns = currency,
      rows = currency < 100
    )
  )

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
