% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_kappa_ice}
\alias{gsw_kappa_ice}
\title{Isentropic Compressibility of Ice}
\usage{
gsw_kappa_ice(t, p)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
isentropic compressibility of ice [ 1/Pa ] (not 1/dbar)
}
\description{
Calculate isentropic compressibility of ice, in 1/Pa.
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
p <- c(      10,       50,      125,      250,       600,     1000)
kappa <- gsw_kappa_ice(t, p)
stopifnot(all.equal(kappa*1e9, c(0.112495239053936, 0.112070687842183, 0.112119091047584,
                                 0.112126504739297, 0.112123513812840, 0.112262589530974)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_kappa_ice.html}
}
\seealso{
Other things related to compressibility: 
\code{\link{gsw_kappa_const_t_ice}()},
\code{\link{gsw_kappa_t_exact}()},
\code{\link{gsw_kappa}()}
}
\concept{things related to compressibility}
