% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_geo_strf_dyn_height}
\alias{gsw_geo_strf_dyn_height}
\title{Geostrophic Dynamic Height Anomaly}
\usage{
gsw_geo_strf_dyn_height(SA, CT, p, p_ref = 0)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{p_ref}{reference pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A vector containing geopotential anomaly in
\eqn{m^2/s^2}{m^2/s^2} for each level. For more on the units, see [2].
}
\description{
This calculates a geopotential anomaly, called either the
dynamic height anomaly or the geostrophic streamfunction
in the TEOS-10 document listed as [1] below; users should
read that and the references therein for more details on
the definition and its calculation here.

To get the column-integrated value in meters, take the first
value of the returned vector and divide by
9.7963\eqn{m/s^2}{m/s^2}. Note that this yields an integral
with the top measured pressure (not zero) as an upper limit.
}
\details{
Because of the scheme used in the underlying C code, the 
pressures must be in order, and must not have any repeats.
Also, there must be at least 4 pressure values. Violating
any of these three restrictions yields an error.

If \code{p_ref} exceeds the largest \code{p} value, a vector
of zeros is returned, in accordance with the underlying C code.

The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
p <- c(      10,      50,     125,     250,     600,    1000)
p_ref <- 1000
dh <- gsw_geo_strf_dyn_height(SA, CT, p, p_ref)
expect_equal(dh, c(17.039204557769487, 14.665853784722286, 10.912861136923812,
                 7.567928838774945, 3.393524055565328, 0))
}
\references{
1. \url{http://www.teos-10.org/pubs/gsw/html/gsw_geo_strf_dyn_height.html}

2. Talley et al., 2011. Descriptive Physical Oceanography, 6th edition, Elsevier.
}
