% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_from_pt}
\alias{gsw_CT_from_pt}
\title{Conservative Temperature from Potential Temperature}
\usage{
gsw_CT_from_pt(SA, pt)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{pt}{potential temperature (ITS-90) [ degC ]}
}
\value{
Conservative Temperature [ degC ]
}
\description{
Conservative Temperature from Potential Temperature
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
pt <- c(28.7832, 28.4209, 22.7850, 10.2305,  6.8292,  4.3245)
CT <- gsw_CT_from_pt(SA, pt)
expect_equal(CT, c(28.809923015982083, 28.439144260767169, 22.786246608464264,
                   10.226165605435785, 6.827183417643142,  4.323565182322069))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_from_pt.html}
}
