\name{transition_probability}
\alias{transition_probability}
\title{Returns transition probability for offspring given one or more parents.}
\usage{
transition_probability(off, mom, dad, multilocus = TRUE)
}
\arguments{
  \item{off}{A locus from the offspring}

  \item{mom}{A locus from one parent}

  \item{dad}{A locus from another parent}

  \item{multilocus}{A flag indicating that a single
  multilocus estiamte of the transition probability should
  be passed (the default action).  If \code{FALSE}, the
  results will be returned as a vector of individual locus
  values.}
}
\value{
The numeric probability of the offspring given the parents
}
\description{
This is a quick function used in paternity testing that
provides the probability of transition for a locus of any
ploidy level.
}
\examples{
off <- locus( 1:2 )
mom <- locus( c(1,1) )
dad1 <- locus( c(2,2) )
dad2 <- locus( c(1,2) )
dad3 <- locus( c(1,1) )
transition_probability( off, mom, dad1 )
transition_probability( off, mom, dad2 )
transition_probability( off, mom, dad3 )
}
\author{
Rodney J. Dyer <rjdyer@vcu.edu>
}

