% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak2peak.R
\name{peak2peak}
\alias{peak2peak}
\title{Maximum-to-minimum difference}
\usage{
peak2peak(x, MARGIN = 2)
}
\arguments{
\item{x}{the data, expected to be a vector, a matrix, an array.}

\item{MARGIN}{a vector giving the subscripts which the function will be
applied over. E.g., for a matrix 1 indicates rows, 2 indicates columns,
c(1, 2) indicates rows and columns. Where \code{x} has named dimnames, it
can be a character vector selecting dimension names. Default: 2 (columns)}
}
\value{
Vector or array of values containing the maximum-to-minimum
  differences of the specified \code{MARGIN} of \code{x}.
}
\description{
Compute the maximum-to-minimum difference of the input data \code{x}.
}
\details{
The input \code{x} can be a vector, a matrix or an array. If the input is a
vector, a single value is returned representing the maximum-to-minimum
difference of the vector. If the input is a matrix or an array, a vector or
an array of values is returned representing the maximum-to-minimum
differences of the dimensions of \code{x} indicated by the \code{MARGIN}
argument.

Support for complex valued input is provided. In this case, the function
\code{peak2peak} identifies the maximum and minimum in complex magnitude, and
then subtracts the complex number with the minimum modulus from the complex
number with the maximum modulus.
}
\examples{
## numeric vector
x <- c(1:5)
pp <- peak2peak(x)

## numeric matrix
x <- matrix(c(1,2,3, 100, 150, 200, 1000, 1500, 2000), 3, 3)
pp <- peak2peak(x)
pp <- peak2peak(x, 1)

## numeric array
x <- array(c(1, 1.5, 2, 100, 150, 200, 1000, 1500, 2000,
             10000, 15000, 20000), c(2,3,2))
pp <- peak2peak(x, 1)
pp <- peak2peak(x, 2)
pp <- peak2peak(x, 3)

## complex input
x <- c(1+1i, 2+3i, 3+5i, 4+7i, 5+9i)
pp <- peak2peak(x)

}
\author{
Georgios Ouzounis, \email{ouzounis_georgios@hotmail.com}.\cr
Conversion to R by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
