% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/welchwin.R
\name{welchwin}
\alias{welchwin}
\title{Welch window}
\usage{
welchwin(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric"}{(Default). Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When 'periodic' is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Welch window, returned as a vector.
}
\description{
Return the filter coefficients of a Welch window of length \code{n}.
}
\details{
The Welch window is a polynomial window consisting of a single parabolic
section:
\deqn{w(k) = 1 - (k / N - 1)^2, n=0,1, ... n-1}.
The optional argument specifies a "symmetric" window (the default) or a
"periodic" window. A symmetric window has zero at each end and maximum in the
middle, and the length must be an integer greater than 2. The variable
\code{N} in the formula above is \code{(n-1)/2}. A periodic window wraps
around the cyclic interval \code{0,1, ... m-1}, and is intended for use
with the DFT. The length must be an integer greater than 1. The variable
\code{N} in the formula above is \code{n/2}.
}
\examples{

w <- welchwin(64)
plot (w, type = "l", xlab = "Samples", ylab =" Amplitude")

ws = welchwin(64,'symmetric')
wp = welchwin(63,'periodic')
plot (ws, type = "l", xlab = "Samples", ylab =" Amplitude")
lines(wp, col="red")

}
\author{
Muthiah Annamalai, \email{muthiah.annamalai@uta.edu},\cr
Mike Gross, \email{mike@appl-tech.com},\cr
Peter V. Lanspeary, \email{pvl@mecheng.adelaide.edu.au}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
