#' growthmodels: Nonlinear Growth Models
#'
#' A compilation of nonlinear growth models used in many areas.
#' 
#' \tabular{ll}{
#'   Package: \tab growthmodels \cr
#'   Version: \tab 1.2.0 \cr
#'   License: \tab GPL-3 \cr
#' }
#'
#' @author Daniel Rodriguez Perez \email{daniel.rodriguez.perez@@gmail.com}
#' 
#' @references
#' D. Fekedulegn, M. Mac Siurtain, and J. Colbert, "Parameter estimation of
#' nonlinear growth models in forestry," Silva Fennica, vol. 33, no. 4, pp.
#' 327-336, 1999.
#' 
#' M. M. Kaps, W. O. W. Herring, and W. R. W. Lamberson, "Genetic and
#' environmental parameters for traits derived from the Brody growth curve and
#' their relationships with weaning weight in Angus cattle.," Journal of
#' Animal Science, vol. 78, no. 6, pp. 1436-1442, May 2000.
#' 
#' A. Tsoularis and J. Wallace, "Analysis of logistic growth models.,"
#' Math Biosci, vol. 179, no. 1, pp. 21-55, Jul. 2002.
#' 
#' A. Khamiz, Z. Ismail, and A. T. Muhammad, "Nonlinear growth models for
#' modeling oil palm yield growth," Journal of Mathematics and Statistics,
#' vol. 1, no. 3, p. 225, 2005.
#' 
#' http://en.wikipedia.org/wiki/Generalised_logistic_function
#' 
#' @name growthmodels-package
#' @aliases growthmodels
#' @docType package
#' 
NULL
