% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_lm.R
\name{grouped_lm}
\alias{grouped_lm}
\title{Function to run linear model (lm) across multiple grouping variables.}
\usage{
grouped_lm(data, grouping.vars, formula, output = "tidy")
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{grouping.vars}{List of grouping variables.}

\item{formula}{an object of class \code{"\link{formula}"} (or one that
    can be coerced to that class): a symbolic description of the
    model to be fitted.  The details of model specification are given
    under \sQuote{Details}.}

\item{output}{A character describing what output is expected. Two possible
options: \code{"tidy"} (default), which will return the results, or \code{"glance"},
which will return model summaries.}
}
\value{
A tibble dataframe with tidy results from linear model.
}
\description{
Function to run linear model (lm) across multiple grouping variables.
}
\examples{

# loading needed libraries
library(ggplot2)

# getting tidy output of results
grouped_lm(
  data = mtcars,
  grouping.vars = cyl,
  formula = mpg ~ am * wt,
  output = "tidy"
)

# getting model summaries
# diamonds dataset from ggplot2
grouped_lm(
  data = diamonds,
  grouping.vars = c(cut, color),
  formula = price ~ carat * clarity,
  output = "glance"
)
}
\seealso{
grouped_slr
}
\author{
Indrajeet Patil
}
