\name{drFit}
\Rdversion{1.1}
\alias{drFit}
\title{
Function to run the dose-response curve fit and EC50 estimation
}
\description{
The function serves to estimate several dose-response curves at once. The function calls the functions \code{\link{drFitSpline}} and \code{\link{drBootSpline}} to generate a table with estimates for EC50 and respecting statistics.
}
\usage{
drFit(gcFitData, control = grofit.control())
}
\arguments{
  \item{gcFitData}{
Data frame containing the data for the dose-response curve estimation. It must follow the convention: 1. column: string, naming the experiment for which a dose-response curve shall be estimated; 2. column: string, additional information about the experiment; 3. column: numeric, concentration of substrate; 4. column: logical, reliability flag, 5. column: string, naming a parametric model, 6. column: logical, indicating wether a logarithmic transformation was applied to the time points of the growth data; 7. column: logical, indicating wether a logarithmic transformation was applied to the growth values of the growth data; 8.-55. characteristic growth parameters obtained from growth curve fit.
}
  \item{control}{
Object of class \code{grofit.control} containing a list of options generated by the function \code{\link{grofit.control}.}
}
}
\details{
The function is meant to process the result from the fit of several growth curves performed by \code{\link{gcFit}}. It therefore expects a certain input format. For each of the distinct experiments specified by the names in the first column, the function relates the concentration (3. column) to a characteristic growth parameter (8.-55. columns). The choice of the parameter depends on the option \code{parameter} specified by the \code{\link{grofit.control}} function. The concentration and parameter are passed to \code{\link{drFitSpline}} and \code{\link{drBootSpline}}, which perform the dose-response curve estimation and bootstrapping.
}
\value{
Generates an object of class \code{drFit}
\item{raw.data}{Data that passed to the function as \code{gcFitData}.}
\item{drTable}{Data frame, 1. column: string, naming the experiment; 2. column: logical, indicating wether a logarithmic transformation was applied to concentration data; 3. column, logical, indicating wether a logarithmic transformation was applied to growth parameter; 4. column, numeric, number of bootstrap samples used; 5.-8. column: numeric, estimated EC50 value and respecting reponse value (5.-6.), also in original scale if a transformation is applied (7.-8.); 9.-10. column: numeric, mean and standard dev. from bootstrap sample; 11.-14. column: 90 and 95 percent confidence interval from bootstrap sample; 15. column: mean EC50 of bootstrap sample in original scale; 16.-19. 90 and 95 percent confidence interval in original scale.}
\item{drBootSplines}{List of all \code{drBootSpline} objects generated by the call of \code{\link{drBootSpline}} for each distinct experiments. Note: access to each object via double brace: \code{LIST[[1]]}, \code{LIST[[2]]}...}
\item{drFittedSplines}{list of all \code{drFitSpline} objects generated by the call of \code{\link{drFitSpline}} for each distinct experiments. Note: access to each object via double brace: \code{LIST[[1]]}, \code{LIST[[2]]}...}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\seealso{
\code{\link{drFitSpline}}, \code{\link{drBootSpline}}, \code{\link{drBootSpline}}, \code{\link{summary.drFit}}, \code{\link{plot.drFit}}
}
\examples{
# generate random growth curve data set
foo <- ran.data(100, 25)
time <- foo$time
data <- foo$data
# fit dose response curves
drData <- gcFit(time, data, control = grofit.control(interactive = FALSE))
# use the output of gcFit as an input for drFit
drFit.result <- drFit(summary(drData))
print(summary(drFit.result))
plot(drFit.result)
}