% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_n_persons}
\alias{sim_n_persons}
\title{Simulate n persons}
\usage{
sim_n_persons(prob, n, a = 10, ap = rep(1/length(a), length(a)))
}
\arguments{
\item{prob}{Probability to draw a construct from a certain category.}

\item{n}{Number of persons, i.e. grids to be sampled.}

\item{a}{Possible number of attributes sampled from.}

\item{ap}{Attribute probabilities, i.e. for each number of attributes given
in \code{a}.}
}
\description{
Function is a simple replicate wrapper around \code{sim_one_person}
}
\examples{
sim_n_persons(dexp(1:30, .05), n = 2, a = 10)
sim_n_persons(dexp(1:30, .05), n = 2, a = c(1, 30))
sim_n_persons(dexp(1:30, .05), n = 2, a = c(1, 30), ap = c(1,4))
sim_n_persons(dexp(1:30, .05), n = 2, a = 1:5, ap = c(1,1,2,2,3))

}
\seealso{
Other Simulations: \code{\link{sim_n_persons_x_times_many_n}},
  \code{\link{sim_n_persons_x_times}},
  \code{\link{sim_one_person}}
}

