% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extractScale}
\alias{extractScale}
\alias{extractScale.default}
\alias{extractScale.greybox}
\alias{extractSigma}
\alias{extractSigma.default}
\alias{extractSigma.greybox}
\title{Functions to extract scale and standard error from a model}
\usage{
extractScale(object, ...)

\method{extractScale}{default}(object, ...)

\method{extractScale}{greybox}(object, ...)

extractSigma(object, ...)

\method{extractSigma}{default}(object, ...)

\method{extractSigma}{greybox}(object, ...)
}
\arguments{
\item{object}{The model estimated using lm / alm / etc.}

\item{...}{Other parameters (currently nothing).}
}
\value{
One of the two is returned, depending on the type of estimated model:
\itemize{
\item Scalar from \code{sigma()} method if the variance is assumed to be constant.
\item Vector of values if the scale model was estimated
}
}
\description{
Functions extract scale and the standard error of the residuals. Mainly needed for
the work with the model estimated via \link[greybox]{sm}.
}
\details{
In case of a simpler model, the functions will return the scalar using
\code{sigma()} method. If the scale model was estimated, \code{extractScale()} and
\code{extractSigma()} will return the conditional scale and the conditional
standard error of the residuals respectively.
}
\examples{
# Generate the data
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+sqrt(exp(0.8+0.2*xreg[,1]))*rnorm(100,0,1),
              xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

# Estimate the location and scale model
ourModel <- alm(y~., xreg, scale=~x1+x2)

# Extract scale
extractScale(ourModel)
# Extract standard error
extractSigma(ourModel)

}
\seealso{
\code{\link[greybox]{sm}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
