% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_estimate.R
\name{estimate}
\alias{estimate}
\alias{estimate.HRMtree}
\alias{estimate.HRMBG}
\alias{estimate.EKS}
\alias{estimate.MMEave}
\alias{estimate.MLEave}
\title{Provides estimation of parameters}
\usage{
estimate(obj, ...)

\method{estimate}{HRMtree}(obj, Data, subsets, k_ratio, xx = NULL, ...)

\method{estimate}{HRMBG}(obj, Data, subsets, k_ratio, xx = NULL, ...)

\method{estimate}{EKS}(obj, Data, coord, k_ratio, ...)

\method{estimate}{MMEave}(obj, Data, k_ratio, ...)

\method{estimate}{MLEave}(obj, Data, k_ratio, ...)
}
\arguments{
\item{obj}{object of on of the following classes \code{MME, MLE1, MLE2, EKS, EKS_part, EngHitz, MME_ave, MLE_ave, HRMBG}.
The classes \code{MME, MLE1, MLE2, EKS, EKS_part, EngHitz} are subclasses of class \code{HRMtree},
hence if no other method is available, the method for \code{HRMtree} applies.}

\item{...}{additional arguments}

\item{Data}{the dataset, it should have named columns.}

\item{subsets}{object of class \code{RootDepSet} containing the roots and the respective subsets.
When \code{obj} is of class \code{EngHitz} the argument \code{subsets} should be a list of subsets,
not a \code{RootDepSet} object. When \code{obj} is of class \code{EngHitz} the union of all subsets should cover
the whole vertex set and also
every pair of subsets can have at most one node in common. See also Vignettes
"Code - Note 4" and "Estimation - Note 4".}

\item{k_ratio}{a scalar the ratio of the number of upper order statistics to the number of observations}

\item{xx}{A vector of length the number of observed variables and named with the names of the nodes with
observed variables.
Default is NULL. For \code{estimate.EKS_part} it should be filled in. For the other methods
the value at default should be kept.}

\item{coord}{A matrix of evaluation points with number of columns equal to the number of nodes in the tree and
column names according to the
names of the nodes.
The matrix of evaluation points should not contain a positive coordinate for a variable which is unobserved.
For creation of coordinates based on tuples, triples, and adjacent nodes see classes
\code{Coordinates}, \code{Tuples}, \code{Triples}, \code{Adjacent} as well as method \code{evalPoints}}
}
\value{
An object of the same class as the argument \code{obj} where the slot \code{$depParams} are the estimates
of edge weights. For objects \code{MME} it returns the squared
values of the parameters.
}
\description{
Estimates the edge weights or edge parameters of a model parameterized cliquewise by Huesler-Reiss
distributions. For description of the model, please consult the Vignette "Introduction".
}
\details{
For an object of class \code{EKS_part} for a fixed subset all coordinates based on both tuples and triples
are taken.
}
\note{
For detailed examples please consult Vignettes "Code - Note" 1-6.
}
