% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_green_index.R
\name{calculate_green_index}
\alias{calculate_green_index}
\title{Calculate Green Index}
\usage{
calculate_green_index(osm_data, crs_code, D = 100, buffer_distance = 120)
}
\arguments{
\item{osm_data}{List containing OSM data (highways, green_areas, trees).}

\item{crs_code}{Coordinate reference system code for transformations.}

\item{D}{Distance decay parameter (default = 100).}

\item{buffer_distance}{Buffer distance for spatial joins (default = 120).}
}
\value{
A spatial data frame with calculated green index.
}
\description{
This function calculates the green index for a given set of OpenStreetMap (OSM) data using DuckDB and Duckplyr.
The green index is calculated based on the proximity of highways to green areas and trees.
}
\examples{
\donttest{
  osm_data <- get_osm_data("Basel, Switzerland")
  green_index <- calculate_green_index(osm_data, 2056)
}
}
