% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_combinedmodels.R
\docType{class}
\name{CombinedModelsPath-class}
\alias{CombinedModelsPath-class}
\title{Combined Models hierarchical fit results class}
\description{
An S4 class to represent a hierarchical fit of a degree corrected stochastic block model, extend \code{\link{IclPath-class}}.
}
\section{Slots}{

\describe{
\item{\code{model}}{a \code{\link{DcSbm-class}} object to store the model fitted}

\item{\code{name}}{generative model name}

\item{\code{icl}}{icl value of the fitted model}

\item{\code{K}}{number of extracted clusters over row and columns}

\item{\code{cl}}{a numeric vector with row and columns cluster indexes}

\item{\code{obs_stats}}{a list with the following elements:}

\item{\code{path}}{a list of size K-1 with each part of the path described by:
\itemize{
\item icl1: icl value reach with this solution for alpha=1
\item logalpha: log(alpha) value were this solution is better than its parent
\item K: number of clusters
\item cl: vector of cluster indexes
\item k,l: index of the cluster that were merged at this step
\item merge_mat: lower triangular matrix of delta icl values
\item obs_stats: a list with the elements:
}}

\item{\code{logalpha}}{value of log(alpha)}

\item{\code{ggtree}}{data.frame with complete merge tree for easy plotting with \code{ggplot2}}

\item{\code{tree}}{numeric vector with merge tree \code{tree[i]} contains the index of \code{i} father}

\item{\code{train_hist}}{data.frame with training history information (details depends on the training procedure)}
}}

\seealso{
\code{\link{extractSubModel,CombinedModelsPath,character-method}}
}
