% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{scale_and_register_data}
\alias{scale_and_register_data}
\title{Register or synchronize different expression profiles}
\usage{
scale_and_register_data(
  input_df,
  stretches,
  shift_extreme,
  num_shifts,
  min_num_overlapping_points,
  initial_rescale,
  do_rescale,
  accession_data_to_transform,
  accession_data_ref,
  start_timepoint = c("reference", "transform", "zero"),
  expression_value_threshold = 5,
  is_data_normalised = FALSE
)
}
\arguments{
\item{input_df}{Input data frame contains all replicates of gene expression in each genotype at each time point.}

\item{stretches}{Candidate registration stretch factors to apply to data to transform.}

\item{shift_extreme}{The absolute maximum value which can be applied as a shift to gene expression time course (days).}

\item{num_shifts}{Number of shifts between minimum and maximum values of shift.}

\item{min_num_overlapping_points}{Number of minimum overlapping time points.  Shifts will be only considered if it leaves at least these many overlapping points after applying the registration function.}

\item{initial_rescale}{Scaling gene expression prior to registration if \code{TRUE}.}

\item{do_rescale}{Scaling gene expression using only overlapping time points points during registration.}

\item{accession_data_to_transform}{Accession name of data which will be transformed.}

\item{accession_data_ref}{Accession name of reference data.}

\item{start_timepoint}{Time points to be added in both reference data and data to transform after shifting and stretching. Can be either \code{"reference"} (the default), \code{"transform"}, or \code{"zero"}.}

\item{expression_value_threshold}{Expression value threshold. Remove expressions if maximum is less than the threshold. If \code{NULL} keep all data.}

\item{is_data_normalised}{TRUE if dataset has been normalised prior to registration process.}
}
\value{
This function returns a list of data frames, containing:

\item{mean_df}{a data frame containing mean expression value of each gene and accession for every time point.}
\item{mean_df_sc}{identical to \code{mean_df}, with additional column \code{sc.expression_value} which the scaled mean expression values.}
\item{to_shift_df}{a processed input data frame which is ready to be registered.}
\item{shifted_mean_df}{the registration result - after stretching and shifting.}
\item{imputed_mean_df}{the imputed (transformed to be the same in a set of common time points) registration result.}
\item{all_shifts_df}{a table containing candidates of registration parameters and a score after applying each parameter (stretch and shift factor).}
\item{model_comparison_df}{a table comparing the optimal registration function for each gene (based on \code{all_shifts_df} scores) to model with no registration applied.}
}
\description{
\code{scale_and_register_data()} is a function to register expression profiles a user wish to compare. This includes an option to scale data before registration, find and calculate score of optimal shifts and stretches, as well as apply the best shifts and stretches.
}
\examples{
\dontrun{
# Load a data frame from the sample data
all_data_df <- system.file("extdata/brapa_arabidopsis_all_replicates.csv", package = "greatR") \%>\%
  utils::read.csv()

# Running the registration
registration_results <- scale_and_register_data(
  input_df = all_data_df,
  stretches = c(3, 2.5, 2, 1.5, 1),
  shift_extreme = 4,
  num_shifts = 27,
  min_num_overlapping_points = 4,
  initial_rescale = FALSE,
  do_rescale = TRUE,
  accession_data_to_transform = "Col0",
  accession_data_ref = "Ro18",
  start_timepoint = "reference"
)
}
}
