% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wage_inflator.R
\name{wage_inflator}
\alias{wage_inflator}
\title{Inflation using the Wage Price Index.}
\usage{
wage_inflator(wage = 1, from_fy = NULL, to_fy = NULL,
  useABSConnection = FALSE, allow.projection = TRUE,
  forecast.series = c("mean", "upper", "lower", "custom"),
  forecast.level = 95, wage.series = NULL,
  accelerate.above = 100000L)
}
\arguments{
\item{wage}{The amount to be inflated (1 by default).}

\item{from_fy, to_fy}{(character) a character vector with each element in the form "2012-13" representing the financial years between which the CPI inflator is desired.

If both \code{from_fy} and \code{to_fy} are \code{NULL} (the default), \code{from_fy} is set to the previous financial year and \code{to_fy} to the current financial year, with a warning. Setting only one is an error.}

\item{useABSConnection}{Should the function connect with ABS.Stat via an SDMX connection? If \code{FALSE} (the default), a pre-prepared index table is used. This is much faster and more reliable (in terms of errors), though of course relies on the package maintainer to keep the tables up-to-date.

If the SDMX connection fails, a message is emitted (not a warning) and
the function contines as if \code{useABSConnection = FALSE}.

The internal data was updated on 2019-05-20 to 2019-Q1.}

\item{allow.projection}{If set to \code{TRUE} the \code{forecast} package is used to project forward, if required.}

\item{forecast.series}{Whether to use the forecast mean, or the upper or lower boundaries of the prediction intervals. A fourth option \code{custom} allows manual forecasts to be set.}

\item{forecast.level}{The prediction interval to be used if \code{forecast.series} is \code{upper} or \code{lower}.}

\item{wage.series}{If \code{forecast.series = 'custom'}, how future years should be inflated. 
The future wage series can be provided in two ways: 
(1) a single value, to be the assumed rate of wage inflation in years beyond the known series, or 
(2) a \code{data.table} with two variables, \code{fy_year} and \code{r}. If (2), 
the variable \code{fy_year} must be a vector of all financial years after the last financial year in the (known) wage series and the latest \code{to_fy} \strong{inclusive}.
The variable \code{r} consists of rates of wage growth assumed in each \code{fy_year}.}

\item{accelerate.above}{An integer setting the threshold for 'acceleration'. 
When the maximum length of the arguments exceeds this value, calculate each unique value individually 
then combine. Set to 100,000 as a rule of thumb beyond which calculation speeds benefit
dramatically. Can be set to \code{Inf} to disable acceleration.}
}
\value{
The wage inflation between the two years.
}
\description{
Predicts the inflation of hourly rates of pay, between two financial years.
}
\examples{
# Wage inflation
wage_inflator(from_fy = "2013-14", to_fy = "2014-15")

# Custom wage inflation
wage_inflator(from_fy = "2016-17",
              to_fy = "2017-18",
              forecast.series = "custom",
              wage.series = 0.05)


}
