% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_super_vars.R
\name{apply_super_caps_and_div293}
\alias{apply_super_caps_and_div293}
\title{Superannuation caps and Division 293 calculations}
\usage{
apply_super_caps_and_div293(.sample.file,
  colname_concessional = "concessional_contributions",
  colname_div293_tax = "div293_tax",
  colname_new_Taxable_Income = "Taxable_income_for_ECT",
  div293_threshold = 3e+05, cap = 25000, cap2 = 35000,
  age_based_cap = TRUE, cap2_age = 59, ecc = FALSE,
  use_other_contr = FALSE, scale_contr_match_ato = FALSE, .lambda = 0,
  reweight_late_lodgers = FALSE, .mu = 1.05,
  impute_zero_concess_contr = FALSE, .min.Sw.for.SG = 450 * 12,
  .SG_rate = 0.0925, warn_if_colnames_overwritten = TRUE,
  drop_helpers = FALSE, copyDT = TRUE)
}
\arguments{
\item{.sample.file}{A data.table containing at least the variables \code{sample_file_1314} from the taxstats package.}

\item{colname_concessional}{The name for concessional contributions.}

\item{colname_div293_tax}{The name of the column containing the values of Division 293 tax payable for that taxpayer.}

\item{colname_new_Taxable_Income}{The name of the column containing the new Taxable Income.}

\item{div293_threshold}{The Division 293 threshold.}

\item{cap}{The cap on concessional contributions for all taxpayers if \code{age_based_cap} is FALSE, or for those below the age threshold otherwise.}

\item{cap2}{The cap on concessional contributions for those above the age threshold. No effect if \code{age_based_cap} is FALSE.}

\item{age_based_cap}{Is the cap on concessional contributions age-based?}

\item{cap2_age}{The age above which \code{cap2} applies.}

\item{ecc}{(logical) Should an excess concessional contributions charge be calculated? (Not implemented.)}

\item{use_other_contr}{Make a (poor) assumption that all 'Other contributions' (\code{MCS_Othr_Contr}) are concessional contributions. This may be a useful upper bound should such contributions be considered important.}

\item{scale_contr_match_ato}{(logical) Should concessional contributions be inflated to match aggregates in 2013-14? That is, should concessional contributions by multiplied by \code{grattan:::super_contribution_inflator_1314}, which was defined to be: \deqn{\frac{\textrm{Total assessable contributions in SMSF and funds}}{\textrm{Total contributions in 2013-14 sample file}}}{Total assessable contributions in SMSF and funds / Total contributions in 2013-14 sample file.}.}

\item{.lambda}{Scalar weight applied to \code{concessional contributions}. \eqn{\lambda = 0} means no (extra) weight. \eqn{\lambda = 1} means contributions are inflated by the ratio of aggregates to the sample file's total. For \eqn{R = \textrm{actual} / \textrm{apparent}} then the contributions are scaled by \eqn{1 + \lambda(R - 1)}.}

\item{reweight_late_lodgers}{(logical) Should WEIGHT be inflated to account for late lodgers?}

\item{.mu}{Scalar weight for WEIGHT. (\eqn{w' = \mu w}) No effect if \code{reweight_late_lodgers} is \code{FALSE}.}

\item{impute_zero_concess_contr}{Should zero concessional contributions be imputed using salary?}

\item{.min.Sw.for.SG}{The minimum salary required for super guarantee to be imputed.}

\item{.SG_rate}{The super guarantee rate for imputation.}

\item{warn_if_colnames_overwritten}{(logical) Issue a warning if the construction of helper columns will overwrite existing column names in \code{.sample.file}.}

\item{drop_helpers}{(logical) Should columns used in the calculation be dropped before the sample file is returned?}

\item{copyDT}{(logical) Should the data table be \code{copy()}d? If the action of this data table is being compared, possibly useful.}
}
\value{
A data table comprising the original sample file (\code{.sample.file}) with extra superannuation policy-relevant variables for the policy specified by the function.
}
\description{
Mutate a sample file to reflect particular caps on concessional contributions and applications of Division 293 tax.
}
\author{
Hugh Parsonage, William Young
}
